/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef WEBWIDGETPREFERENCE_H
#define WEBWIDGETPREFERENCE_H

#include <QObject>
#include <QString>
#include <QHash>
#include "widgetcoreglobal.h"

namespace WRT {

    /**
            @author Nokia User,,, <mobuntu@mobuntu-vm>
    */

    /**
    *  PrefElement
    *
    *
    */
    class PrefElement : public QObject
        {
    public :
        /**
        * Constructor.
        */
        PrefElement();

        /**
        * Destructor.
        */
        ~PrefElement();

        /**
        * setValueL
        * Set value for a preference
        * @param const QString& aValue - The value to be set
        * @return none
        */
        void setValue( const QString& value );

        /**
        * setValueSize
        * Set length of value
        * @param const int size - The length to be set
        * @return none
        */
        void setValueSize( const int size ) {
            m_valueSize = size;
        }

        /**
        * setCleanFileFlag
        * @param TBool cleanFileFlag
        * @return none
        */
        void setCleanFileFlag( const bool cleanFileFlag ) {
            m_cleanFileFlag = cleanFileFlag;
        }

        /**
        * GetValue
        * Get value for a preference
        * @param none
        * @return QString - value for the preference
        */
        QString value() const {
            if ( !m_value.isNull() )
                return m_value;
            else
                return QString();
        }

        /**
        * GetValueSize
        * Get length of value
        * @param none
        * @return int - length of value for the preference
        */
        int valueSize() const { return m_valueSize; }

    private :
        QString  m_value;     // value of the preference: if size > MAX, it's the file name which stores the value
        int    m_valueSize; // length of the value
        bool   m_cleanFileFlag;  // flag for deleteing individual preference dat file
    };


    class WIDGETCORE_EXPORT WebWidgetPreference : public QObject
    {
        Q_OBJECT

        public:
            WebWidgetPreference();

            ~WebWidgetPreference();

        public:
            void setWidgetBundleId(const QString& value);
            QString widgetBundleId() const;
            void setBasePath(const QString& value);
            QString basePath() const;
            /**
            * Load preferences from persistent storage
            */
            void load();

            /**
            * Save preferences to persistent storage
            */
            void save();

            /**
            * Get preference for a particular key
            */
            bool preference( const QString& key, QString& value);

            /**
            * Set preference for a particular key
            */
            void setPreference( const QString& key, const QString& value);

        private:
            QString m_widgetBundleId;
            QString m_basePath;
            QHash<QString, PrefElement*> *m_preferences;
            bool m_load;
    };


}

#endif
