/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WEBRENDERER_H
#define WEBRENDERER_H

#include <QWidget>

class QTimer;

namespace WRT {

    class WebRenderer : public QWidget
    {
        Q_OBJECT
        Q_PROPERTY(QColor fadeColor READ fadeColor WRITE setFadeColor)
        Q_PROPERTY(int fadeDuration READ fadeDuration WRITE setFadeDuration)
    public:

        WebRenderer(QWidget *parent);

        QColor fadeColor() const { return startColor; }
        void setFadeColor(const QColor &newColor) { startColor = newColor; }

        int fadeDuration() const { return duration; }
        void setFadeDuration(int milliseconds) { duration = milliseconds; }

        void start();

    protected:
        void paintEvent(QPaintEvent *event);

    private:
        QTimer *timer;
        QColor startColor;
        int currentAlpha;
        int duration;
    };

}

#endif
