/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __WEBJSMENUITEM_H
#define __WEBJSMENUITEM_H

//  INCLUDES
#include <QObject>
#include <QString>
#ifdef CWRT_BUILDING_TENONE
#include <HbMenu>
#endif

// FORWARD DECLARATION
class QMenu;

// FUNCTION PROTOTYPES

namespace WRT {

    // FORWARD DECLARATION
    class WebJSMenuItem;
    class WebJSMenu;

    // CLASS DECLARATION
    class WebJSMenuItemPrivate
    {
    public:
        WebJSMenuItemPrivate(WebJSMenu* menu, double id, const QString& label);
        ~WebJSMenuItemPrivate();

    public:
        WebJSMenu* m_menu;
        double     m_id;
        QString m_label;
        bool    m_dimmed;
        QList<WebJSMenuItem*>             m_children;
    };


    /**
    *  WebJSMenuItem
    *
    */
    class WebJSMenuItem : public QObject
    {
        Q_OBJECT

    public:
        WebJSMenuItem(WebJSMenu* menu, double id, const QString& label);
        ~WebJSMenuItem();

        double id();
        QString& label();
        bool hasChildren();
        void constructUIMenu(QMenu* menu);
#ifdef CWRT_BUILDING_TENONE
        void constructUIMenu(HbMenu *menu);
#endif
        void append(WebJSMenuItem* subMenuItem);
        void remove(double id);
        void setDimmed(bool dimmed);
        // recursive
        WebJSMenuItem* getMenuItemById(double id);
        WebJSMenuItem* getMenuItemByName(const QString& label);
        void clear();
        // debug use
        void printArray(int level);

    public slots:
            void onSelectMenuItem();

    private:
        WebJSMenuItemPrivate*                 d;

    };

}

#endif
/*
    var menu = new Menu();

    function Menu() {
        this = widget.createMenu(title, callback);
    }

    var menu = widget.createMenu(title, callback);


    testObject = new Object;


    widget.wrt = new Object;
    widget.wrt.menu = new Object;
    var v = widget.wrt.version()

    var m = new Menu();
    m.text = "afdasf";

    <script language="text/qscript">QScript script; </script>
    <script language="text/javascript">JavaScript script; </script>



//frame->evaluateJavaScript("widget.wrt = new Object;");
//frame->evaluateJavaScript("widget.wrt.version = " + myVersion() );

//frame->evaluateJavaScript("widget.wrt.__defineGetter("version", mywrappedqobject.gettheversion()"));


    var m = new Menu();

*/
