/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __WEBJSMENU_H
#define __WEBJSMENU_H

//  INCLUDES
#include <QObject>
#include <QString>
#include <QList>
#include <QVariant>
#include <QMetaType>
#ifdef CWRT_BUILDING_TENONE
#include <HbMenu>
#endif

// FORWARD DECLARATION
class QMenu;

// FUNCTION PROTOTYPES

namespace WRT {

    // FORWARD DECLARATION
    class WebJSMenuItem;
    class WidgetContainer;

    // CLASS DECLARATION
    class WebJSMenuPrivate
    {
    public:
        WebJSMenuPrivate(WidgetContainer* wrtWidgetContainer);
        ~WebJSMenuPrivate();

    public:
        WidgetContainer*        m_wrtWidgetContainer;
        QList<WebJSMenuItem*>   m_children;
        QString                 m_LSKlabel;
        QString                 m_RSKlabel;
        bool                    m_SKvisible;
    };


    /**
    *  WebJSMenu
    *
    */
    class WebJSMenu : public QObject
    {
        Q_OBJECT

        public:
            WebJSMenu(WidgetContainer* wrtWidgetContainer);
            ~WebJSMenu();

            // called from UI
            QMenu* constructUIMenu(QMenu* uiMenu = 0);
#ifdef CWRT_BUILDING_TENONE
            HbMenu* constructUIMenu(HbMenu* uiMenu = 0);
#endif

            QString leftSoftkeyLabel();
            QString rightSoftkeyLabel();
            bool isSoftkeyVisible();

        signals:
            void softkeysChanged();
            void windowCloseRequested();

        public slots:
            bool append(double id, const QString& label);
            void onSelectMenuItem(double id);
            void remove(double id);
            void clear();
            void setLeftSoftkeyLabel(const QString& label);
            void setRightSoftkeyLabel(const QString& label);
            void showSoftkeys();
            void hideSoftkeys();
            // These slots are not published in API document
            // They're for assisting MenuItem operations in JavaScript
            bool appendToMenuItem(int parentId, double childId, const QString& childLabel);
            void removeFromMenuItem(int parentId, double childId);
            void setDimmed(double id, bool dimmed);
            bool isExisting(double id, const QString& label);
            // fire JS callback
            void onShowMenu();

            // debug use
            // print webjsmenuitems to log
            void printArray();
            void printMessage(const QString& message);

        protected:
            bool eventFilter(QObject *obj, QEvent *event);

        private:
            WebJSMenuItem* getMenuItemById(double id);
            WebJSMenuItem* getMenuItemByName(const QString& label);

        private:
            WebJSMenuPrivate*                 d;
    };

}

#endif
