/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WEBJSWRT_H__
#define __WEBJSWRT_H__

#include <qobject.h>
#include <QApplication>
#include <QDebug>
#include "wrtsettings.h"

#define NOTAVAILABLE "N/A"

namespace WRT {

    class WidgetContainer;

    class PlatformPrivate
    {
    public:
        PlatformPrivate();

        QString m_id;
        QString m_romVersion;
        QString m_packageVersion;
        QString m_manufacturer;
        QString m_model;
        QString m_reversion;
    };

    class Platform
    {
    public:
        QString id() { return m_pltPrivate.m_id; }
        QString romVersion() { return implRomVersion(); }
        QString packageVersion() {return implPackageVersion(); }
        QString manufacturer() { return implManufacturer(); }
        QString model() { return implModel(); }
        QString revision() { return implRevision(); }
        virtual ~Platform() {};
    protected:
        virtual QString implPackageVersion() {return m_pltPrivate.m_packageVersion;}
        virtual QString implRomVersion() { return m_pltPrivate.m_romVersion; }
        virtual QString implManufacturer() { return m_pltPrivate.m_manufacturer; }
        virtual QString implModel() { return m_pltPrivate.m_model; }
        virtual QString implRevision() { return m_pltPrivate.m_reversion; }

        PlatformPrivate m_pltPrivate;
    };

    class Win32Platform : public Platform
    {
    public:
         Win32Platform() { m_pltPrivate.m_id = "Win32";}
         ~Win32Platform() {}
    };

    class LinuxPlatform : public Platform
    {
    public:
         LinuxPlatform() { m_pltPrivate.m_id = "Linux";}
         ~LinuxPlatform() {}
    };

    class S40Platform : public Platform
    {
    public:
         S40Platform() { m_pltPrivate.m_id = "S40";}
         ~S40Platform() {}
    };

    class MaemoPlatform : public Platform
    {
    public:
         MaemoPlatform() { m_pltPrivate.m_id = "Maemo";}
         ~MaemoPlatform() {}
    };

    class SuperJSPlatform : public QObject
    {
    Q_OBJECT
    public:
        Q_PROPERTY(QString id READ id)
        Q_PROPERTY(QString romVersion READ romVersion)
        Q_PROPERTY(QString packageVersion READ packageVersion)
        Q_PROPERTY(QString manufacturer READ manufacturer)
        Q_PROPERTY(QString model READ model)
        Q_PROPERTY(QString revision READ revision)

        SuperJSPlatform();
        ~SuperJSPlatform();
        SuperJSPlatform& operator=(const SuperJSPlatform&){ return *this;};
        QString id() {return m_platformInstance->id();}
        QString romVersion() { return m_platformInstance->romVersion();}
        QString packageVersion() { return m_platformInstance->packageVersion();}
        QString manufacturer() {return m_platformInstance->manufacturer();}
        QString model() {return m_platformInstance->model();}
        QString revision() {return m_platformInstance->revision();}

    private:
        Platform* m_platformInstance;
    };

    class SuperJSWrt : public QObject
    {
    Q_OBJECT
    public:
        Q_PROPERTY(QString version READ version)
        Q_PROPERTY(QObject* platform READ platform)

        SuperJSWrt(WidgetContainer* wrtWidgetContainer);
        QString version(){return WrtSettings::getWrtVersion();}

        QObject* platform() const{return m_platform;}
        ~SuperJSWrt();

    protected:
        WidgetContainer* m_wrtWidgetContainer;
        SuperJSPlatform* m_platform;
    };

}

#endif
