/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QtCore>
#include <QVariant>
#include "superjswidget.h"
#include "webwidgetpreference.h"
#include "superjswrt.h"


using namespace WRT;

// LOCAL FUNCTION PROTOTYPES

// ----------------------------------------------------------------------------
// SuperJSWidgetPrivate::
//
//
//
// ----------------------------------------------------------------------------
//
SuperJSWidgetPrivate::SuperJSWidgetPrivate( WidgetContainer* wrtWidgetContainer ) :
                                        m_wrtWidgetContainer(wrtWidgetContainer)
{
   m_wrt = new SuperJSWrt(wrtWidgetContainer);
}

SuperJSWidgetPrivate::~SuperJSWidgetPrivate()
{
    delete m_wrt;
}

// ----------------------------------------------------------------------------
// SuperJSWidget::
//
//
//
// ----------------------------------------------------------------------------
//
SuperJSWidget::SuperJSWidget(WidgetContainer* wrtWidgetContainer)
{
    d = new SuperJSWidgetPrivate(wrtWidgetContainer);
}

SuperJSWidget::~SuperJSWidget()
{
    delete d;
}

QString SuperJSWidget::identifier() const
{
    return d->m_wrtWidgetContainer->widgetPreference()->widgetBundleId();
}

QObject* SuperJSWidget::jsWrt() const
{
    return d->m_wrt;
}

QVariant SuperJSWidget::preferenceForKey(const QVariant& key)
{
    QVariant value;

    bool isKeyValid = key.isValid();
    if (!isKeyValid)
        return value;

    QMetaType::Type keyType = (QMetaType::Type) key.type();
    if (keyType != QMetaType::QString)
        return value;

    QString valueStr;
    QString keyStr = key.toString();
    bool ret = d->m_wrtWidgetContainer->widgetPreference()->preference(keyStr, valueStr);

    if (!valueStr.isNull())
        value = QVariant(valueStr);

    return value;
}

void SuperJSWidget::setPreferenceForKey(const QVariant& value, const QVariant& key)
{
    bool isValueValid = value.isValid();
    bool isKeyValid = key.isValid();

    if (!isKeyValid)
        return;

    QMetaType::Type keyType = (QMetaType::Type) key.type();
    if (keyType != QMetaType::QString)
        return;

    QString keyStr = key.toString();
    if (!isValueValid)
        d->m_wrtWidgetContainer->widgetPreference()->setPreference(keyStr, QString());
    else
    {
        QMetaType::Type valueType = (QMetaType::Type) value.type();
        switch (valueType) {
            case QMetaType::Double:
            case QMetaType::Bool:
            case QMetaType::QString: {
                QString valueStr = value.toString();
                d->m_wrtWidgetContainer->widgetPreference()->setPreference(keyStr, valueStr);
            }
                break;

            default:
                break;
        }
    }
}

void SuperJSWidget::openURL(QString url)
{
    qDebug() << "openURL: " << url;
    d->m_wrtWidgetContainer->openURL(url);
}

void SuperJSWidget::notificationRecieved(WidgetContainer::WrtWidgetNotify value)
{
    //Not implemented as there are no common UI events at the moment
}
