# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
TEMPLATE = lib
DEFINES += BUILDING_WIDGET_CORE
QT += network webkit
TARGET = WrtWidgetCore
LIBS += -lWrtRuntimeCore -lWrtWidgetUtils -lWrtSecurityManager -lWrtSettings -lWrtDialogsProvider -lWrtSecureStorage


# establish relative root dir
ROOT_DIR = $$PWD/../..
WRT_DIR = $$ROOT_DIR/wrt

include($$WRT_DIR/cwrt-webkit.pri)
include($$WRT_DIR/wrt.pri)
include($$PWD/network/network.pri)
include($$PWD/widgetengine/widgetengine.pri)

include($$PWD/wrtapis/wrtapis.pri)

INCLUDEPATH += $$CWRT_INCLUDE $$PWD/wrtapis

CONFIG += \
    building-libs \
    depend_includepath \
    dll \
    link_prl \
    create_prl

contains(QT_CONFIG, embedded): CONFIG += embedded

CONFIG(release, debug|release):!CONFIG(QTDIR_build){
    contains(QT_CONFIG, reduce_exports): CONFIG += hide_symbols
    contains(QT_CONFIG, reduce_relocations): CONFIG += bsymbolic_functions
}

CONFIG -= warn_on
*-g++* : QMAKE_CXXFLAGS += -Wreturn-type -fno-strict-aliasing

include(widgetcore.pri)
include($$PWD/../services-tmp/services-tmp.pri)

#
# INCLUDE PATHS
#
INCLUDEPATH += \
    $$PWD \
    $$PWD/network \
    $$PWD/widgetengine \
    $$PWD/../ \
    $$PWD/../runtimecore \
    $$PWD/../security \
    $$PWD/../services-tmp \
    $$PWD/../services-tmp/DownloadService \
    $$PWD/../services-tmp/WebServices \
    $$PWD/../utilities/ConnectionManager/BearerManager \
    $$PWD/../utilities/ConnectionManager \
    $$PWD/../utilities/DialogsProvider \
    $$PWD/../utilities/DownloadMgr/DownloadManager/inc \
    $$PWD/../utilities/UserAgent \
    $$PWD/../widgetmanager/src \
    $$PWD/../widgetmanager/src/W3CXmlParser \
    $$PWD/../settings/inc \
    $$PWD/../securestorage

INCLUDEPATH +=  $$PWD/platform/maemo/
