/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QPluginLoader>
#include <QDir>
#include <QDebug>

#include "javascriptextensioninterface.h"
#include "serviceprovider.h"
#include "serviceloader.h"
#include "pluginserviceprovider.h"

#include "wrtpage.h"
#include "qwebframe.h"

const QString PLUGINS_DIR("/usr/lib/cwrt/plugins/");


namespace WRT { namespace Maemo {


    void ServiceProvider::setFeatures(QStringList features) {
        m_features = features;
        qDebug() << "Capas are " << m_features;
    }

    void ServiceProvider::handleNewInstance(WRT::ServiceLoader* loader
                                           ) {

        foreach(QString feature, m_features) {

            // one ugly hack to form up full path from the feature
            QString pluginPath(PLUGINS_DIR);
            pluginPath.append("lib");
            pluginPath.append(feature);
            pluginPath.append("Plugin.so");

            QPluginLoader pluginLoader(pluginPath);
            NokiaAPI::JavaScriptExtensionInterface* iface;
            QObject* plugin = pluginLoader.instance();

            if (plugin) {
                iface = qobject_cast<NokiaAPI::JavaScriptExtensionInterface*>(plugin);
                iface->setServiceLoader(*loader);
                loader->addService(iface->name(), *plugin);
                m_plugins.append(plugin);
            } else {
                qDebug()<<"Failed to load plugin"<<pluginPath;

            }
        }
        m_serviceLoader = loader;
    }


    void ServiceProvider::destroyInstance(WRT::ServiceLoader* loader) {
        Q_UNUSED(loader);

        foreach (QObject* plugin, m_plugins) {
            m_plugins.removeOne(plugin);
            delete plugin;
        }
    }

    void ServiceProvider::pageOnReload() {
        foreach (QObject* plugin, m_plugins) {
            NokiaAPI::JavaScriptExtensionInterface* iface = qobject_cast<NokiaAPI::JavaScriptExtensionInterface*>(plugin);
            iface->pageOnReload();
        }
    }

    void ServiceProvider::injectCommonCode(QString resourcePathToJs) {
        QFile f(resourcePathToJs);
        if (!f.open(QIODevice::ReadOnly)) {
            // this is critical error and must not happen
            qFatal("Could not open internal JavaScript files!");
        }
        QString fullScript("");
        QTextStream in(&f);
        while (!in.atEnd()) {
            fullScript.append(in.readLine() + "\n");
        }

        m_serviceLoader->getContext()->currentFrame()->evaluateJavaScript(fullScript);
    }

    QObject* ServiceProvider::getPluginObjectByName(QString name) {
        foreach (QObject* plugin, m_plugins) {
            NokiaAPI::JavaScriptExtensionInterface* iface =
                qobject_cast<NokiaAPI::JavaScriptExtensionInterface*>(plugin);
            if (iface->name() == name) {

                return plugin;
            }
        }
        return 0;
    }
    NokiaAPI::JavaScriptExtensionInterface* ServiceProvider::getPluginByName(QString name) {
        foreach (QObject* plugin, m_plugins) {
            NokiaAPI::JavaScriptExtensionInterface* iface =
                qobject_cast<NokiaAPI::JavaScriptExtensionInterface*>(plugin);
            if (iface->name() == name) {
                return iface;
            }
        }
        return 0;


    }


}}

