/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef APPLICATIONLAUNCHER_H
#define APPLICATIONLAUNCHER_H

#include <QObject>
#include <QString>
#include <QStringList>
#include <QUrl>

#include "wrtsettings.h"

class QNetworkReply;
class QNetworkAccessManager;
class QProcess;

namespace WRT {

    namespace Maemo {

        class MimeHandlerPluginFactory;

        /** Application launcher.
          * This class is responsible for launching applications based
          * on mime type or application path. Uses DBus when launching
          * the browser.
          */
        class ApplicationLauncher : public QObject {

                Q_OBJECT

            public:
                ApplicationLauncher(QObject* parent = 0);
                ~ApplicationLauncher();

            public slots:

                void replyFinished(QNetworkReply*);

                /** Launches application.
                  * Launches arbitrary application to a different process.
                  * @param app Full path to the application to be launched.
                  * @param params Parameters that are passed to the application.
                  */
                bool launchApplication(QString app, QStringList params);

                /** Launches application with given parameters.
                  * Launches application based on mime type or if the
                  * mime type is text/html then the Fennec browser is used.
                  * @param mimeType Mime type to be handled.
                  * @param url Parameters that are passed to the application.
                  */
                bool launchApplication(QString mimeType, QUrl url);

                /** Launches application or browser based on URL.
                  * Launches application based on URL to a different process.
                  * If the URL can be handled by the browser then it is used.
                  * @param url URL to be opened.
                  * @return True if the application was launched, false otherwise.
                  */
                bool launchUrl(const QUrl& url);

                private slots:
                void readOutput();
            private:
                void redirect(const QUrl&);
                void setProxy();
                QNetworkAccessManager* manager;
                QUrl startUrl;
                MimeHandlerPluginFactory* typeFactory;
                QProcess* m_proc;
        };
    }
}

#endif
