/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "wrtnetworkerrorreply.h"

namespace WRT {


/*!
 * \class NetworkErrorReply
 * A specialization of the abstract base class QNetworkReply. This can be returned by
 * WebNetworkAccessManager::createRequest() to generate an error without actually
 * submitting a request to the network, thus blocking network access.
 */

/*!
 * Constructor
 * \param[in] errorCode - The error code to set
 * \param[in] errorString - The error text to set
 */


  WrtNetworkErrorReply::WrtNetworkErrorReply(NetworkError errorCode, const QString& errorString, const QUrl& url)
    : QNetworkReply()

  {
    setError(errorCode,errorString);
    setUrl(url);
  }

  void WrtNetworkErrorReply::abort()
  {

  }

  qint64 WrtNetworkErrorReply::readData(char* data, qint64 size){
    return 0;
  }
}
