/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRTNETWORKACCESSMANAGER_P_H__
#define __WRTNETWORKACCESSMANAGER_P_H__

#define DISKCACHESIZE 2*1024*1024

#include <QNetworkDiskCache>

class QWidget;

namespace WRT {

class CookieJar;
class SchemeHandler;
class SecSession;
class UserAgent;
class CookieJar;
class WRTNetworkFilterListener;

class WrtNetworkAccessManagerPrivate
{
public:
    WrtNetworkAccessManagerPrivate(WidgetContainerBase* widgetContainerBase, QWidget* wrtView);
    ~WrtNetworkAccessManagerPrivate();

    QHash<QString, QString> m_hostRequestHeaders;
    SchemeHandler* m_schemeHandler;
    SecSession* m_secSession;
    UserAgent* m_userAgent;
    QList<WRTNetworkFilterListener*> m_wrtNetworkFilterListener;
    CookieJar* m_cookieJar;
#if defined(USE_PRIVATEHTTPCACHE)
    FeatherWeightCache *m_qDiskCache;
#else
    QNetworkDiskCache *m_qDiskCache;
#endif
    WidgetContainerBase* m_widgetContainerBase;
    WrtPage* m_wrtPage;
    QWidget* m_wrtView;

    int m_widgetId;
    QString m_appPath;
#ifdef CWRT_WIDGET_FILES_IN_SECURE_STORAGE
    Storage* m_storage;
#endif
};

}
#endif
