/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRTNETWORKACCESSMANAGER_H__
#define __WRTNETWORKACCESSMANAGER_H__

#include <QNetworkAccessManager>
#include <QUrl>
#include <QNetworkRequest>
#include "wrtwidgetcontainerBase.h"

namespace WRT {

class WrtPage;
class SecSession;
class WrtNetworkAccessManagerPrivate;
class WrtNetworkReply;

class WrtNetworkAccessManager : public QNetworkAccessManager
{
Q_OBJECT

private:
    struct PendingRequest {
        QNetworkAccessManager::Operation op;
        QNetworkRequest request;
        QIODevice*  outgoingdata;
        QNetworkReply* reply;
    };
public:
    WrtNetworkAccessManager(WidgetContainerBase* widgetContainerBase, QWidget* wrtView);
    virtual ~WrtNetworkAccessManager();

    void clearCookies();
    void setSecuritySession(SecSession* secSession);
    SecSession* securitySession() const;
    void setHostRequestHeader(const QString& name, const QString& value);
    void setBasePath(const QString& basePath);

public slots:
    void slotAuthenticationRequired(QNetworkReply*, QAuthenticator*);
    void slotProxyAuthenticationRequired(const QNetworkProxy &, QAuthenticator *);
    void handleConnection();
    void connectionError();
    void abortPendingRequest(WrtNetworkReply* reply);
private slots:
    /** Called whenever SSL error occurs.
      * @param reply Network reply.
      * @param erros List of errors that happened.
      */
    void slotSslError(QNetworkReply* reply, const QList<QSslError>& errors);

signals:
    void createConnection();

protected:
    virtual QNetworkReply *createRequest(Operation op,
                                         const QNetworkRequest &request,
                                         QIODevice *outgoingData = 0);
    virtual void setupCache();
    virtual int preprocessNetworkRequest(const Operation &op, QNetworkRequest &request);
    virtual void addWhiteListEntriesForOrigin(QString origin);

private:
    bool fileAccessBlocked(const QString& urlPath);
    bool accessAllowed(const QNetworkRequest &request);
    QString getWidgetRoot();
    static QString fixupHTTPcachePath(const QString &templateForm);
    void enableCrossOriginXHR(QUrl requestUrl);
private:
    WrtNetworkAccessManagerPrivate* d;
    QList<PendingRequest> m_pendingRequests;
    bool m_connected;
};

}
#endif
