/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WPERFORMANCE_H
#define WPERFORMANCE_H

#include <QTime>
#include <QString>

namespace wperf {
class benchmarker {
    public:
        benchmarker(QString msg, uint iterations = 1) : mIterations(iterations), mCount(iterations), mMessage(msg) {
            // do at least one iteration
            if (mIterations == 0) {
                mIterations = 1;
            }
            // start the timer
            mTime.start();
            qDebug() << QString("====> %1").arg(msg);
        };

        ~benchmarker() {
            // get the elapsed time
            int t = mTime.elapsed();
            if (mCount == 1) {
                qDebug() << QString("====> %1 took %2 milliseconds").arg(mMessage).arg(t);
            }
            else if (mCount != 0) {
                // calculate an average based on the number of iterations
                t /= mCount;
                qDebug() << QString("====> %1 took an average of %2 milliseconds per iteration (total of %3 iterations)").arg(mMessage).arg(t).arg(mCount);
            }
        };

        uint iterate() {
            return mIterations--;
        }

    private:
            uint mIterations;
            uint mCount;
            QTime mTime;
            QString mMessage;
};

// prints a timestamp with given prefix
#define WTS(XXX) do { \
    QString s(XXX); \
    QTime ts = QTime::currentTime(); \
    qDebug() << ts.toString("====> %1 hh:mm:ss.zzz").arg(s); \
} while (0);


// prints time spent in milliseconds with given prefix
#define WBM(XXX) for (wperf::benchmarker b(XXX); b.iterate() != 0;)

} // namespace
#endif // WPERFORMANCE_H
