/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QDebug>
#include <QDir>
#include <QFileInfo>
#include <QFile>
#include "CertificateManagerMaemo.h"
#include "widgetmanagerconstants.h"

namespace WRT {

    CertificateManagerMaemo::CertificateManagerMaemo()
    {
    }
    CertificateManagerMaemo::~CertificateManagerMaemo()
    {
    }

    bool CertificateManagerMaemo::retrieveDeviceCertificate(QByteArray topLevel, QByteArray& cert)
    {
        QString aki = getAuthorityKeyIdentifier(topLevel);
        QString widgetCertPath = CERTIFICATE_PATH;

        // go through all certificates in widgetCertPath
        // the call to getSubjectKeyIdentifier assumes cert will be in .pem format
        QDir certDir = QDir(widgetCertPath);
        qDebug() << "widgetCertPath: " << widgetCertPath;
        QStringList certList = certDir.entryList(QDir::Files | QDir::NoDotAndDotDot);
        qDebug() << "certList size: " << certList.size();
        while (!certList.isEmpty()) {
            QString certPath = certList.takeFirst();
            certPath.prepend(widgetCertPath + QDir::separator());
            QFile f(certPath);
            qDebug() << "Testing certificate: "+ certPath << " Size= "<< f.size();
            f.open(QIODevice::ReadOnly);
            QByteArray certByteArray(f.readAll());

            QString ski = getSubjectKeyIdentifier(certByteArray);
            // pick a cert whose ski matches aki, convert to bytearray and return
            if (ski == aki) {
                cert = certByteArray;
                return true;
            }
        }

        return false;
    }

    /**
      * Takes a certificate from the widget's signature.xml x509 element, gets the AKI from the cert,
      * and chain validates the certificate stored locally against the trust root.
      *
      * Qt implementation does not perform chain validation - there is only 1 cert in the chain
      */
  bool CertificateManagerMaemo::validateCertificates(QList<QByteArray> certs, QByteArray endEntity, QByteArray topLevel)
    {
       return CertificateManager::validateCertificates(certs, endEntity, topLevel);
    }
}
