/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef SERVICEPROXY_H_
#define SERVICEPROXY_H_

#include <QObject>
#include <QMetaObject>
#include <QMetaType>
#include <QtGlobal>
#include <QList>
#include <QVariant>
#include <QVector>
#include <QHash>
#include <QList>
#include <QDebug>
#include <QtScript/qscriptengine.h>

namespace WRT {

    class ServiceProxy : public QObject {

        public:
            ServiceProxy(QObject& service, bool giveToGarbageCollector);
            ~ServiceProxy();

            virtual int qt_metacall(QMetaObject::Call c, int id, void **arguments);
            const QMetaObject *metaObject() const;
            void *qt_metacast(const char *className);
            void initialize();

            QScriptEngine::ValueOwnership objectOwnership();
        public slots:
            void testi() {
                qDebug()<<"Testing";
            }

        private:
            bool isValid();
            QString getLastError();

        private:
            QObject& m_serviceObject;
            bool m_valid;
            QString m_lastError;
            bool m_isInitialized;
            bool m_giveToGarbageCollector;
    };
}

#endif

