# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

TEMPLATE = lib
CONFIG += plugin
QT += core 
TARGET = WrtApiTelephony

include(../cwrtservice.pri)

symbian{
INCLUDEPATH += $$CWRT_INCLUDE \
               platform/s60

HEADERS = telephonyserviceplugin.h \
    telephonyservice.h \
    telephonyinterface.h \
    constants.h
    
SOURCES = telephonyserviceplugin.cpp \
    telephonyservice.cpp
}

maemo{

  maemo5 {
    DEFINES += __MAEMO__
    INCLUDEPATH += $$CWRT_INCLUDE \
                   ./platform/maemo5
    HEADERS = ./telephonyserviceplugin.h \
              ./telephonyinterface.h
    SOURCES = ./telephonyserviceplugin.cpp

  } else {
    # maemo6
    INCLUDEPATH += $$CWRT_INCLUDE \
                   platform/maemo

    DEFINES += __MAEMO__

    HEADERS = telephonyserviceplugin.h \    
    telephonyinterface.h

    SOURCES = telephonyserviceplugin.cpp \
  }
}

symbian { 
	INCLUDEPATH += platform/s60\
				   /epoc32/include/osextensions\
		   		   /epoc32/include/domain/middleware
    			   
    HEADERS += platform/s60/telephonyprovider.h
    					 
    SOURCES += platform/s60/telephonyprovider.cpp
    					 
    LIBS += -lefsrv -lPlatformEnv -letel3rdparty
    TARGET.CAPABILITY = ALL -TCB
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 =  0x20026150
    VERSION  = 3.0.0
    
    TARGET.sources = ./descriptionxml/telephonyserviceplugin.xml
    TARGET.path = /private/102829B8/import
    DEPLOYMENT += TARGET
  #  QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E
}

maemo {

  maemo5 {

    HEADERS += ./platform/maemo5/telephonyservice.h
    HEADERS += ./platform/maemo5/constants.h
    SOURCES += ./platform/maemo5/telephonyservice.cpp

    # Build against wrt-dev package
    cwrt-services {
        INCLUDEPATH -= ../../../inc
        INCLUDEPATH += /usr/include/cwrt/security
        INCLUDEPATH += /usr/include/cwrt/servicefw
    }

    INCLUDEPATH += $$CWRT_INCLUDE \
                   $$LOCSVC_INC_PATH

  } else {
    # maemo6
    LIBS += /usr/lib/libcallui0.so

    HEADERS += platform/maemo/telephonyservice.h
    HEADERS += platform/maemo/constants.h
    SOURCES += platform/maemo/telephonyservice.cpp

    INCLUDEPATH += $$CWRT_INCLUDE \
        $$LOCSVC_INC_PATH \
        /usr/include/call-ui/
  }
}
