/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef TELEPHONYSERVICEPLUGIN_H_
#define TELEPHONYSERVICEPLUGIN_H_

//INLCUDES
#include <QtCore>
#include "serviceplugininterface.h"

// CLASS DECLARATION

/**
*  The class defines the methods for plugin instantiation
*  of Telephony service provider
*  @lib telephonyserviceplugin.qtplugin
*  @since x.y
*/
class TelephonyServicePlugin : public QObject, IServicePlugin
{
    Q_OBJECT
    Q_INTERFACES(IServicePlugin)

public:
    //public interfaces

    /**
    * Constructor
    */
    TelephonyServicePlugin();

    /**
    * Destructor
    */
    virtual ~TelephonyServicePlugin();

protected:
    // inherited methods

    /**
    * This API is used to instantiate telephony service provider
    * @since 1.0
    * @param refCounted - true indicated reference counted object,
    *                     singleton object
    * @param secSession - pointer to Security Manager session - not owned
    * @return Interface pointer to telephony Service object
    */
    IServiceBase* getServiceBase(bool refCounted, WRT::SecSession *secSession);
};

#endif //TELEPHONYSERVICEPLUGIN_H_
