/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef TELEPHONYINTERFACE_H
#define TELEPHONYINTERFACE_H

//INCLUDES
#include <QtCore>
#include <QVariant>
#include <QMap>
#include "servicebase.h"

static const char* KITelephonyId = "com.nokia.ITelephony/1.0";

// ITelephony interface id
static const ServiceInterfaceInfo KITelephonyInfo =
{
        KITelephonyId, 0
};

// CLASS DECLARATION

/**
*  The class defines the interface for telephony methods.
*  @lib telephonyserviceplugin.qtplugin
*  @since 1.0
*/

class ITelephony : public IServiceBase
{
public:
    /**
    * Interface function for telephony.
    * Makes a voice call to a number.
    * This is a sycnhronous method.
    * @since 1.0
    * @param phoneNumber number to which the voice call should be made.
    * @return Returns map with error code & message.
    */
    virtual QVariant initiateVoiceCall( QString phoneNumber ) = 0;

};
Q_DECLARE_INTERFACE(ITelephony, KITelephonyId);


#endif //TELEPHONYINTERFACE_H
