# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#


TEMPLATE = lib
CONFIG += plugin

!maemo5 {
LIBS += -lsecmgr
}
maemo5 {
LIBS += -lWrtSecurityManager
}

symbian {
CONFIG(debug):SYSINFOSVC_SRC_PATH = ./platform/s60/
CONFIG(debug):SYSINFOSVC_INC_PATH = ./platform/s60/
CONFIG(release):SYSINFOSVC_SRC_PATH = ./platform/s60/
CONFIG(release):SYSINFOSVC_INC_PATH = ./platform/s60/
}
maemo{
  maemo5 {
    CONFIG(debug):SYSINFOSVC_SRC_PATH = ./platform/maemo5/
    CONFIG(debug):SYSINFOSVC_INC_PATH = ./platform/maemo5/
    CONFIG(release):SYSINFOSVC_SRC_PATH = ./platform/maemo5/
    CONFIG(release):SYSINFOSVC_INC_PATH = ./platform/maemo5/
    CONFIG(release):DEFINES += QT_NO_DEBUG_OUTPUT
  }
  else {
    CONFIG(debug):SYSINFOSVC_SRC_PATH = ./platform/maemo/
    CONFIG(debug):SYSINFOSVC_INC_PATH = ./platform/maemo/
    CONFIG(release):SYSINFOSVC_SRC_PATH = ./platform/maemo/
    CONFIG(release):SYSINFOSVC_INC_PATH = ./platform/maemo/
  }
}
symbian {
HEADERS += $$SYSINFOSVC_INC_PATH/activerequests.h \
                         $$SYSINFOSVC_INC_PATH/activestore.h \
                         $$SYSINFOSVC_INC_PATH/deviceinfo.h \
                         $$SYSINFOSVC_INC_PATH/entitykeys.h \
                         $$SYSINFOSVC_INC_PATH/sysinfo.h \
                         $$SYSINFOSVC_INC_PATH/sysinfoservice.h \
                         $$SYSINFOSVC_INC_PATH/sysinfoutils.h \
                         $$SYSINFOSVC_INC_PATH/sysnetworkrequest.h \
                         $$SYSINFOSVC_INC_PATH/sysconnectionrequest.h \
                         $$SYSINFOSVC_INC_PATH/sysrange.h \
                         $$SYSINFOSVC_INC_PATH/sysrequest.h \
                         qsysinfoserviceinterface.h \
     			 qsysinfoserviceplugin.h \
    			 $$SYSINFOSVC_INC_PATH/qsysinfoservice.h
    
SOURCES += $$SYSINFOSVC_SRC_PATH/sysinfoservice.cpp \
					 $$SYSINFOSVC_SRC_PATH/activerequests.cpp \
				   $$SYSINFOSVC_SRC_PATH/activestore.cpp \
					 $$SYSINFOSVC_SRC_PATH/sysinfoutils.cpp \
					 $$SYSINFOSVC_SRC_PATH/sysinfo.cpp \
					 $$SYSINFOSVC_SRC_PATH/sysnetworkrequest.cpp \
					 $$SYSINFOSVC_INC_PATH/sysconnectionrequest.cpp \
					 $$SYSINFOSVC_SRC_PATH/deviceinfo.cpp \
				   qsysinfoserviceplugin.cpp \
					 $$SYSINFOSVC_SRC_PATH/qsysinfoservice.cpp \
}
maemo{
  maemo5 {
    HEADERS += $$SYSINFOSVC_INC_PATH/qsysinfoservice.h \
               $$SYSINFOSVC_INC_PATH/qsysinfokeys.h \
               $$SYSINFOSVC_INC_PATH/listdriveinfo.h \
               qsysinfoserviceinterface.h \
               qsysinfoserviceplugin.h

    SOURCES += $$SYSINFOSVC_SRC_PATH/qsysinfoservice.cpp \
               $$SYSINFOSVC_INC_PATH/listdriveinfo.cpp \
               qsysinfoserviceplugin.cpp
  }
  else {
    HEADERS += $$SYSINFOSVC_INC_PATH/qsysinfoservice.h \
               $$SYSINFOSVC_INC_PATH/qsysinfokeys.h \
               $$SYSINFOSVC_INC_PATH/qgetchnltask.h \
               qsysinfoserviceinterface.h \
               qsysinfoserviceplugin.h \
               $$SYSINFOSVC_INC_PATH/isi_info_priv.h \
               $$SYSINFOSVC_INC_PATH/publicidreciever.h \
               $$SYSINFOSVC_INC_PATH/isi_info_mod.h \
               $$SYSINFOSVC_INC_PATH/timezones.h \
               $$SYSINFOSVC_INC_PATH/listdriveinfo.h

    SOURCES += $$SYSINFOSVC_SRC_PATH/qsysinfoservice.cpp \
               qsysinfoserviceplugin.cpp \
               $$SYSINFOSVC_SRC_PATH/qgetchnltask.cpp \
               $$SYSINFOSVC_SRC_PATH/publicidreciever.cpp \
               $$SYSINFOSVC_SRC_PATH/timezones.cpp \
               $$SYSINFOSVC_SRC_PATH/listdriveinfo.cpp
  }
}

TARGET = WrtApiSysInfo
include(../cwrtservice.pri)

symbian {
    LIBS += -lefsrv \
        -lPlatformEnv \
        -lhal \
        -leuser \
        -lbafl \
        -letelmm \
        -letel \
        -letel3rdparty \
        -lAccClient \
        -lAccPolicy \
        -lusbman \
        -lConnMon \
        -lActivityManager \
        -lPtiEngine \
        -lcentralrepository \
        -lws32 \
        -lFEATMGR \
        -lsysutil \
        -lbtengsettings \
        -laknswallpaperutils \
        -lPlatformEnv \
        -lavkon \
        -ltimezonelocalization \
        -ltzclient \
        -leikcore \
        -lcone \
        -lhwrmlightclient \
        -lhwrmvibraclient \
        -lbafl \
        -letext \
        -lestor \
        -ldevvideo 

	notWINSCW = \
    	"$${LITERAL_HASH}if !defined(WINSCW)" \
    	"LIBRARY secenv.lib" \
    	"$${LITERAL_HASH}endif"

	MMP_RULES += notWINSCW
    
    INCLUDEPATH += /epoc32/include/osextensions \
        /epoc32/include/middleware \
        /epoc32/include/domain/middleware \
        /epoc32/include/domain/osextensions \
        /epoc32/include/applications \
        /epoc32/include/domain/applications \
        /epoc32/include/domain/osextensions/loc \
        /epoc32/include/domain/middleware/loc \
        /epoc32/include/domain/applications/loc \
        /epoc32/include/domain/osextensions/loc/sc \
        /epoc32/include/domain/middleware/loc/sc \
        /epoc32/include/domain/applications/loc/scS \
        /epoc32/include/internal  
    TARGET.CAPABILITY = ALL \
        -TCB
    TARGET.VID = VID_DEFAULT
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 = 0x20026151
    VERSION = 3.0.0
    
    TARGET.sources = ./descriptionxml/sysinfoserviceplugin.xml
    TARGET.path = /private/102829B8/import
    DEPLOYMENT += TARGET
   # QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E
 
}
maemo{
  maemo5 {
    TARGET.sources = ./descriptionxml/sysinfoserviceplugin.xml

    # Build against wrt-dev package
    cwrt-services {
        LIBS += -L/usr/lib -lWrtSecurityManager
        INCLUDEPATH += /usr/include/cwrt/security
        INCLUDEPATH += /usr/include/cwrt/servicefw
    }
    CONFIG += link_pkgconfig
    PKGCONFIG += gstreamer-0.10
    PKGCONFIG += gconf-2.0
    PKGCONFIG += x11
    LIBS += -lQtBearer
    INCLUDEPATH += $$CWRT_INCLUDE \
                   $$SYSINFOSVC_INC_PATH \
		   /usr/include/gstreamer-0.10
  } else {
    LIBS += /usr/lib/libcellular-qt.so
    LIBS += /usr/lib/libcontextsubscriber.so
    LIBS +=  /usr/lib/libisi.so
    LIBS += -lqmsystem

    TARGET.sources = ./descriptionxml/sysinfoserviceplugin.xml
    INCLUDEPATH += $$CWRT_INCLUDE \
                   /usr/include/qmsystem \
                   /usr/include/cellular-qt \
                   /usr/include/sensord \
                   /usr/include/contextsubscriber \
                   $$SYSINFOSVC_INC_PATH/ \
                   /usr/include/ISI/ \
                   /usr/include/ISI/rnd/ \
                   /usr/include/qt4/QtMobility \
		   /usr/include/gstreamer-0.10
  }
}
