/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __SENDMESSAGE_H__
#define __SENDMESSAGE_H__

//QT Includes
#include <QObject>
#include <QRunnable>
#include <QVariant>
#include <QMap>
#include <QString>
#include <QStringList>
#include <QMessageService>
#include "messagedata.h"

QTM_USE_NAMESPACE

class QSendMessage : public QObject
{
    Q_OBJECT

public:
    QSendMessage();
    virtual ~QSendMessage();

public:
    int transactionId() const {return iTransactionId;}
    void sendMessageAsync(MessageData &messageData, int aTransactionId);
    void destroyIfFinished();
    bool moreRecipients() const {return !iRecipientsList.isEmpty();}

public slots:
    void sendFinished(QMessageService::State);

private slots:
    void doSend();

signals:
    void completed(QSendMessage*, int, int, QString);
    void doSendSignal();

private:
    void sendMessage();
    void sendErrorCallback();

private:
    int iTransactionId;
    MessageData iMessageData;
    QStringList iRecipientsList;
    QList<QMessageService::State> iServiceState;
    QMessageService * m_service;
    QMessageAccountId iSmsAccId;
};

#endif //__SENDMESSAGE_H__
