/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef qmediagetlistiterator_h
#define qmediagetlistiterator_h

#include <QObject>
#include <QVariant>
#include "iterable.h"



/**
* Media list object iterator. 
* 
*/
class QMediaGetListIterator : public QObject, public WRT::IIterable
{
    Q_OBJECT

public slots:

    /**
    * Resets the iterator
    *
    *
    */
    void reset();

    /**
    * Check if there is next item available
    *
    * @return false if there are no more data elements to be fetched;
    *         true otherwise
    * 
    */
    bool hasNext();
    
    /**
    * Get current item in the collection and get ready for next item.
    *
    * @return current data entry
    * 
    */
    QVariant next();

    /** 
    * Free resources in the collection
    */
    void close();
    
public:
    /** 
    * C++ constructor
    * @param aList array of media meta data
    * @return new QMediaGetListIterator object
    */
    QMediaGetListIterator(QVariantList aList);
    
    ~QMediaGetListIterator();

private:
    QVariantList iList;
    QListIterator<QVariant> * iIterator;
};
#endif //qmediagetlistiterator_h

