/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef qmediaerrorcodes_h
#define qmediaerrorcodes_h

const int KErrorBase = 100;

/**
* Supported error codes. 
* 
*/
enum deviceError
        {
        NO_ERROR = 0,
        MISSING_ARG_ERR = 1,
        INVALID_ARG_ERR  =2,
        NOT_SUPPORTED_ERR =3,
        TIMEOUT_ERR   = KErrorBase,
        DATA_NOT_FOUND_ERR ,
        DATA_ALREADY_EXISTS_ERR ,
        SERVICE_BUSY_ERR  ,
        SERVICE_IN_USE_ERR ,
        DATA_OUT_OF_RANGE_ERR ,
        NOT_ALLOWED_ERR ,
        SIZE_EXCEEDED_ERR ,
        INVALID_URI_ERR ,
        URI_NOT_FOUND_ERR ,
        URI_ALREADY_EXISTS_ERR ,
        GENERAL_ERROR
        };

#endif /* qmediaerrorcodes_h */
