/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _MEDIA_CONTENT_HELPER_H_
#define _MEDIA_CONTENT_HELPER_H_

#include <QString>

#define MAX_LENGHT_DET 4096 //the maximum length needed to determine content type

class MediaContentHelper
{
public:
    /**
     * Gets mime type of file provided by URI
     * @param aFileUri File Uri
     * @param aMimeTypeByContent On return, contains mime type determined by file content. If result is uncertain, it is equal to aMimeTypeByExtension
     * @param aMimeTypeByExtension On return, contains mime type determined by file extension
     * @return Error code
     * @retval NO_ERROR - mime type is retrieved successfully
     * @retval URI_NOT_FOUND_ERR - file not found
     * @retval NOT_SUPPORTED_ERR - directory is specified instead of file
     * @since x.y
     */
    static int getMimeType(const QString& aFileUri, QString& aMimeTypeByContent, QString& aMimeTypeByExtension);
};

#endif // _MEDIA_CONTENT_HELPER_H_
