/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef GETMEDIALISTTASK_H
#define GETMEDIALISTTASK_H

#include <QRunnable>
#include <QObject>
#include <QVariant>
#include <QString>
#include <QMutex>

#include "mediafilter.h"

// Class representing get media list task. Provides methods to run task asynchronously in separate thread

class GetMediaListTask : public QObject, public QRunnable
{
    Q_OBJECT

public:
// Constructor
// matchPattern Data structure containing information regarding getList request

    GetMediaListTask(qint32 transaction_id, const MediaFilter& matchPattern);

    ~GetMediaListTask();
// Finishes the task. Task becomes deleted after invoking this method. This MUST be called by client during signalGetListCb signal processing

    void finishTask();


Q_SIGNALS:
// Signal which is emitted when getting of media list is completed. Reciever client MUST call aTask->finishTask() to free task resources

    void signalGetListCb(GetMediaListTask* aTask, qint32 aTransactionId, int aErrorCode, QVariantList aList);

private:
//    method invoked by QThreadPool to perform task in separate thread
    void run();

//Get list of music data. Just calls getMedia with appropriate arguments related to music type

    QVariantList getMusic();

// Get list of video data. Just calls getMedia with appropriate arguments related to video type

    QVariantList getVideos();

//   Get list of image data. Just calls getMedia with appropriate arguments related to image type

    QVariantList getImages();

//     Get list of streams data. Just calls getMedia with appropriate arguments related to media stream type
    QVariantList getStreams();


private:
    qint32 iTransactionId;
    MediaFilter iMatchPattern;
    QVariantList iMediaFiles;
    static  QMutex iMutex;

};

#endif // GETMEDIALISTTASK_H
