/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#include <QStringList>
#include <QDateTime>
#include <QDebug>


#include "qmediaerrorcodes.h"
#include "getmedialisttask.h"
#include "qmediakeyconstants.h"
#include "msselect.h"
#include "rdfselect.h"

QMutex GetMediaListTask::iMutex;

GetMediaListTask::GetMediaListTask(qint32 transaction_id, const MediaFilter& matchPattern)
    : iTransactionId(transaction_id),iMatchPattern(matchPattern)
{
}

void GetMediaListTask::finishTask()
{
}

GetMediaListTask::~GetMediaListTask()
{
}

void GetMediaListTask::run()
{
    iMutex.lock();

    qDebug("GetMediaListTask::run(): transaction id=%d", iTransactionId )  ;
    qDebug() << "Type is " << iMatchPattern.mediaType();

    switch (iMatchPattern.mediaType())
    {
    case KMFALL:
        iMediaFiles += QVariantList(getMusic());
        iMediaFiles += QVariantList(getImages());
        iMediaFiles += QVariantList(getVideos());
        //  iMediaFiles += QVariantList(getStreams(iMatchPattern));
        break;
    case KMFIMAGE:
        iMediaFiles += QVariantList(getImages());
        break;
    case KMFVIDEO:
        iMediaFiles += QVariantList(getVideos());
        break;
    case KMFAUDIO:
        iMediaFiles += QVariantList(getMusic());
        break;
    case KMFSTREAM:
        iMediaFiles += QVariantList(getStreams());
        break;
    default:
        break;
    }

    emit signalGetListCb(this, iTransactionId, NO_ERROR, iMediaFiles);

    qDebug("GetMediaListTask::run() - end")  ;
    iMutex.unlock();
}


QVariantList GetMediaListTask::getMusic()
{
    qDebug() << Q_FUNC_INFO;

    RDFselect select(CONTENT_MUSIC);
    select.addColumn(MPrefixFile+MFieldSize);
    select.addColumn(MPrefixFile+MFieldDate);
    select.addColumn(MPrefixFile+MFieldMime);
    select.addColumn(MPrefixFile+MFieldPath);
    select.addColumn(MPrefixFile+MFieldCopyright);
    select.addColumn(MPrefixAudio+MFieldComment);
    select.addColumn(MPrefixAudio+MFieldReleaseDate);
    select.addColumn(MPrefixAudio+MFieldTitle);
    select.addColumn(MPrefixAudio+MFieldGenre);
    select.addColumn(MPrefixAudio+MFieldTrack);
    //select.addColumn(MPrefixAudio+MFieldComposer);
    select.addColumn(MPrefixAudio+MFieldAlbum);
    select.addColumn(MPrefixAudio+MFieldArtist);

    switch (iMatchPattern.filterFlags())
    {
    case KMFTITLE:
        select.setQueryPropertyName(MPrefixAudio+MFieldTitle);
        break;
    case KMFARTIST:
        select.setQueryPropertyName(MPrefixAudio+MFieldArtist);
        break;
    case KMFALBUM:
        select.setQueryPropertyName(MPrefixAudio+MFieldAlbum);
        break;
    case KMFGENRE:
        select.setQueryPropertyName(MPrefixAudio+MFieldGenre);
        break;
    case KMFTRACK:
        select.setQueryPropertyName(MPrefixAudio+MFieldTrack);
        break;
        //    case  KMFDATE:
        //        select.setQueryPropertyName(MPrefixFile+MFieldDate);
        //        break;
        //    case KMFCOMPOSER:
        //        select.setQueryPropertyName(MPrefixAudio+MFieldComposer);
        //      break;
    default:
        select.setQueryPropertyName(NULL);

        break;
    }

    select.setQueryPropertyValue(iMatchPattern.filterValue());

    switch (iMatchPattern.sortFlags())
    {
    case KMFTITLE:
        select.setQuerySortBy(MPrefixAudio+MFieldTitle);
        break;
    case KMFARTIST:
        select.setQuerySortBy(MPrefixAudio+MFieldArtist);
        break;
    case KMFALBUM:
        select.setQuerySortBy(MPrefixAudio+MFieldAlbum);
        break;
    case KMFGENRE:
        select.setQuerySortBy(MPrefixAudio+MFieldGenre);
        break;
    case KMFTRACK:
        select.setQuerySortBy(MPrefixAudio+MFieldTrack);
        break;
    case  KMFDATE:
        select.setQuerySortBy(MPrefixFile+MFieldDate);
        break;
        //    case KMFCOMPOSER:
        //        select.setQuerySortBy(MPrefixAudio+MFieldComposer);
        //        break;
    default:
        select.setQuerySortBy(MPrefixFile+MFieldDate);
        break;
    }
    select.setSortMethod((bool)(iMatchPattern.sortMethod()));


    if( iMatchPattern.startTime().isNull() == false && iMatchPattern.endTime().isNull() == false )
    {
        select.setTimeInterval( iMatchPattern.startTime() , iMatchPattern.endTime() );
    }


    if(!select.makeSelect())
    {qDebug()<<"unsuccessfull  select";}

    return select.result();
}


QVariantList GetMediaListTask::getImages()
{
    qDebug() << Q_FUNC_INFO;

    RDFselect select(CONTENT_IMAGES);
    select.addColumn(MPrefixFile+MFieldSize);
    select.addColumn(MPrefixFile+MFieldDate);
    select.addColumn(MPrefixFile+MFieldMime);
    select.addColumn(MPrefixFile+MFieldPath);
    select.addColumn(MPrefixFile+MFieldCopyright);
    select.addColumn(MPrefixImage+MFieldComments);
    select.addColumn(MPrefixImage+MFieldWidth);
    select.addColumn(MPrefixImage+MFieldHeight);
    select.addColumn(MPrefixImage+MFieldTitle);
    select.addColumn(MPrefixImage+MFieldCameraMake);
    select.addColumn(MPrefixImage+MFieldCameraModel);
    select.addColumn(MPrefixImage+MFieldISOSpeed);
    select.addColumn(MPrefixImage+MFieldFNumber);
    select.addColumn(MPrefixImage+MFieldFocalLenght);
    select.addColumn(MPrefixImage+MFieldOrientation);
    select.addColumn(MPrefixImage+MFieldMeteringMode);
    select.addColumn(MPrefixImage+MFieldFlash);
    select.addColumn(MPrefixImage+MFieldWhiteBalance);
    select.addColumn(MPrefixImage+MFieldExposureTime);
    select.addColumn(MPrefixImage+MFieldOriginalDate);


    switch (iMatchPattern.filterFlags())
    {
    case KMFTITLE:
        select.setQueryPropertyName(MPrefixImage+MFieldTitle);
        break;

    case KMFGENRE:
        select.setQueryPropertyName(MPrefixImage+MFieldGenre);
        break;

    default:
        select.setQueryPropertyName(NULL);

        break;
    }

    select.setQueryPropertyValue(iMatchPattern.filterValue());


    switch (iMatchPattern.sortFlags())
    {
    case KMFTITLE:
        select.setQuerySortBy(MPrefixImage+MFieldTitle);
        break;

    case KMFGENRE:
        select.setQuerySortBy(MPrefixImage+MFieldGenre);
        break;

    case  KMFDATE:
        select.setQuerySortBy(MPrefixFile+MFieldDate);
        break;

    default:
        select.setQuerySortBy(MPrefixFile+MFieldDate);
        break;
    }
    select.setSortMethod((bool)(iMatchPattern.sortMethod()));

    if( iMatchPattern.startTime().isNull() == false && iMatchPattern.endTime().isNull() == false )
    {
        select.setTimeInterval( iMatchPattern.startTime() , iMatchPattern.endTime() );
    }

    if(!select.makeSelect())
    {qDebug()<<"getImages: unsuccessfull  select";}

    return select.result();
}


QVariantList GetMediaListTask::getVideos()
{

    qDebug() << Q_FUNC_INFO;


    RDFselect select(CONTENT_VIDEOS);
    select.addColumn(MPrefixFile+MFieldSize);
    select.addColumn(MPrefixFile+MFieldDate);
    select.addColumn(MPrefixFile+MFieldMime);
    select.addColumn(MPrefixFile+MFieldPath);
    select.addColumn(MPrefixFile+MFieldCopyright);
    select.addColumn(MPrefixVideo+MFieldComments);
    select.addColumn(MPrefixVideo+MFieldWidth);
    select.addColumn(MPrefixVideo+MFieldHeight);
    select.addColumn(MPrefixVideo+MFieldTitle);
    select.addColumn(MPrefixVideo+MFieldDuration);

    switch (iMatchPattern.filterFlags())
    {
    case KMFTITLE:
        select.setQueryPropertyName(MPrefixVideo+MFieldTitle);
        break;
    case KMFARTIST:
        select.setQueryPropertyName(MPrefixVideo+MFieldArtist);
        break;
    case KMFGENRE:
        select.setQueryPropertyName(MPrefixVideo+MFieldGenre);
        break;
    case KMFTRACK:
        select.setQueryPropertyName(MPrefixVideo+MFieldTrack);
        break;
    case KMFDURATION:
        select.setQueryPropertyName(MPrefixVideo+MFieldDuration);
        break;

    default:
        select.setQueryPropertyName(NULL);
        break;
    }

    select.setQueryPropertyValue(iMatchPattern.filterValue());


    switch (iMatchPattern.sortFlags())
    {
    case KMFTITLE:
        select.setQuerySortBy(MPrefixVideo+MFieldTitle);
        break;
    case KMFARTIST:
        select.setQuerySortBy(MPrefixVideo+MFieldArtist);
        break;
    case KMFGENRE:
        select.setQuerySortBy(MPrefixVideo+MFieldGenre);
        break;
    case KMFTRACK:
        select.setQuerySortBy(MPrefixVideo+MFieldTrack);
        break;
    case  KMFDATE:
        select.setQuerySortBy(MPrefixFile+MFieldDate);
        break;
    case  KMFDURATION:
        select.setQuerySortBy(MPrefixFile+MFieldDuration);
        break;
    default:
        select.setQuerySortBy(MPrefixFile+MFieldDate);
        break;
    }
    select.setSortMethod((bool)(iMatchPattern.sortMethod()));

    if( iMatchPattern.startTime().isNull() == false && iMatchPattern.endTime().isNull() == false )
    {
        select.setTimeInterval( iMatchPattern.startTime() , iMatchPattern.endTime() );
    }

    if(!select.makeSelect())
    {qDebug()<<"getVideos: unsuccessfull  select";}

    return select.result();
}


QVariantList GetMediaListTask::getStreams()
{
    qDebug() << Q_FUNC_INFO;


    MSselect* select=new MSselect();

    select->makeSelect();

    QVariantList list(select->result());

    delete select;
    return list;
}


