/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _ADD_MUSIC_HANDLER_H_
#define _ADD_MUSIC_HANDLER_H_

#include <QObject>
#include <QStringList>



/**
 * Class representing handler of add music to collection task
 * @lib libmediaserviceplugin.so
 * @since x.y
 */
class AddMusicHandler : public QObject
{
    Q_OBJECT

public:
    /**
     * Constructor
     * @since x.y
     */
    AddMusicHandler(qint32 aTransactionId, const QString& aUri);

    /**
     * Starts adding music. The client should connect to 'musicAdded' signal before
     * @param aErrorCode On return, contains NO_ERROR if starting was successful
     * @param aErrorMessage On return, contains error message
     * @since x.y
     */
    void start(int& aErrorCode, QString& aErrorMessage);

    /**
     * Finish adding music. Deletes handler. The client should call this while processing 'musicAdded' signal (or if start was not successful)
     * @since x.y
     */
    void finish();

    /**
     * Destructor
     * @since x.y
     */
    ~AddMusicHandler();

Q_SIGNALS:
    /**
     * Emitted as signal whenever 'start' completes
     * @param aHandler Identifies fandler which emits such signal. Client should delete handler after receiving of this signal
     * @param aTransactionId uniquely identifies an 'addMusicToCollection' async request.
     * @param aErrorCode error that has occured
     * @return none
     * @since x.y
     */
    void musicAdded(AddMusicHandler* aHandler, int aTransactionId, int aErrorCode);

private:


    /**
     * Checks if file object is available in tracker DB. This is useful to detect that file is not actually a music file.
     * @return true if music specified by iUri is added to tracker DB
     * @since x.y
     */
    bool checkFileIndexed() const;

    /**
     * Checks that iUri is correct
     * @param aErrorCode On return, contains error code
     * @param aErrorCode On return, contains error message
     * @return 'true' if error should be reported asynchronously
     * @since x.y
     */
    bool checkCorrectUri(int& aErrorCode, QString& aErrorMessage) const;
private:
    int iTransactionId;
    QString iUri;

};

#endif // _ADD_MUSIC_HANDLER_H_
