/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef FILESYSTEM_H_
#define FILESYSTEM_H_

//INCLUDED
#include <QMap>
#include <QVariant>
#include <QFileSystemWatcher>
#include <QStringList>
#include <QDir>
#include <QTextStream>
#include <QDebug>
#include <sys/statfs.h>
#include <mntent.h>

#include "fsmountpointinterface.h"

//FORWARD DECLARATION
class FileSystemWorker;

//Use #include <linux/magic.h> instead this hardcode
enum
{
       ADFS_SUPER_MAGIC     = 0xadf5,
       AFFS_SUPER_MAGIC     = 0xADFF,
       BEFS_SUPER_MAGIC     = 0x42465331,
       BFS_MAGIC            = 0x1BADFACE,
       CIFS_MAGIC_NUMBER    = 0xFF534D42,
       CODA_SUPER_MAGIC     = 0x73757245,
       COH_SUPER_MAGIC      = 0x012FF7B7,
       CRAMFS_MAGIC         = 0x28cd3d45,
       DEVFS_SUPER_MAGIC    = 0x1373,
       EFS_SUPER_MAGIC      = 0x00414A53,
       EXT_SUPER_MAGIC      = 0x137D,
       EXT2_OLD_SUPER_MAGIC = 0xEF51,
       EXT2_SUPER_MAGIC     = 0xEF53,
       EXT3_SUPER_MAGIC     = 0xEF53,
       HFS_SUPER_MAGIC      = 0x4244,
       HPFS_SUPER_MAGIC     = 0xF995E849,
       HUGETLBFS_MAGIC      = 0x958458f6,
       ISOFS_SUPER_MAGIC    = 0x9660,
       JFFS2_SUPER_MAGIC    = 0x72b6,
       JFS_SUPER_MAGIC      = 0x3153464a,
       MINIX_SUPER_MAGIC    = 0x137F, /* orig. minix */
       MINIX_SUPER_MAGIC2   = 0x138F, /* 30 char minix */
       MINIX2_SUPER_MAGIC   = 0x2468, /* minix V2 */
       MINIX2_SUPER_MAGIC2  = 0x2478, /* minix V2, 30 char names */
       MSDOS_SUPER_MAGIC    = 0x4d44,
       NCP_SUPER_MAGIC      = 0x564c,
       NFS_SUPER_MAGIC      = 0x6969,
       NTFS_SB_MAGIC        = 0x5346544e,
       OPENPROM_SUPER_MAGIC = 0x9fa1,
       PROC_SUPER_MAGIC     = 0x9fa0,
       QNX4_SUPER_MAGIC     = 0x002f,
       REISERFS_SUPER_MAGIC = 0x52654973,
       ROMFS_MAGIC          = 0x7275,
       SMB_SUPER_MAGIC      = 0x517B,
       SYSV2_SUPER_MAGIC    = 0x012FF7B6,
       SYSV4_SUPER_MAGIC    = 0x012FF7B5,
       TMPFS_MAGIC          = 0x01021994,
       UDF_SUPER_MAGIC      = 0x15013346,
       UFS_MAGIC            = 0x00011954,
       USBDEVICE_SUPER_MAGIC= 0x9fa2,
       VXFS_SUPER_MAGIC     = 0xa501FCF5,
       XENIX_SUPER_MAGIC    = 0x012FF7B4,
       XFS_SUPER_MAGIC      = 0x58465342,
       _XIAFS_SUPER_MAGIC   = 0x012FD16D,
       UBIFS_SUPER_MAGIC    = 0x24051905,
       SYSFS_MAGIC          = 0x62656572,
       DEVPTS_SUPER_MAGIC   = 0x1cd1,
       S_MAGIC_SECURITYFS   = 0x73636673
};

// CLASS DECLARATION
/**
 *  This class deals with the apis
 *  which are maemo specific.
 *  @lib filesytemserviceplugin.qtplugin
 *  @since x.y
 */
class FileSystem : public QObject, public IMountPoint
    {
    Q_OBJECT
public:
    //Constrcutor
    FileSystem();
    FileSystem(FileSystemWorker* aParent);

    //Destructor
    virtual ~FileSystem();

    //gets list of mount points available drives on device
    QList<QVariant> getMountPoints();

    //gets list of default paths available on device based on content type
    QList<QVariant> getDefaultPath(QString contentType);

    //notifies any mount or unmount events
    bool notifyMountEvents();

    void notifyMountEvent();
    //cancels notification
    void cancelNotify();

    //check the validity of the URI
    bool checkPath(QString &Uri);

    QStringList readMountPoints();
    qint32 fsType(const QString& mountPoint);
    qulonglong freeSpaceInfo(const QString& mountPoint);
    qulonglong fullSpaceInfo(const QString& mountPoint);
    bool isMpRW(const QString& mountPoint);

private slots:
    //new drive change event
    void dirChangedEvent(const QString&);
    //new file change event
    void fileChangedEvent(const QString&);

private:
    //Handle to memory card notification class
    QFileSystemWatcher* m_watcher;
    QStringList m_currentInfo;

    //Handle to File System worker
    FileSystemWorker* m_FSWorker;
    };

#endif /* FILESYSTEM_H_ */
