/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef MOUNTPOINTINTERFACE_H
#define MOUNTPOINTINTERFACE_H

#include <QVariant>

// CLASS DECLARATION

/**
 *  The class defines the interface for platform specific methods.
 *  @lib filesystemserviceplugin.qtplugin
 *  @since x.y
 */

class IMountPoint
    {
public:
    virtual ~IMountPoint(){};

    /**
     * Interface function for getMountPoints.
     * gets the available mount points on device
     * @return list of available mount points
     */
    virtual QList<QVariant> getMountPoints() = 0;

    /**
     * Interface function for getDefaultPath.
     * gets the available default paths on device based on content type
     * @param contentType - type of the content like audio, video etc;
     * @return list of available default paths
     */
    virtual QList<QVariant> getDefaultPath(QString contentType) = 0;

    /**
     * Interface function for notifyMountEvents.
     * notifies when any mount/unmount event happens
     */
    virtual bool notifyMountEvents() = 0;

    /**
     * Interface function for cancelNotify.
     * cacels the active notfication request
     */
    virtual void cancelNotify() = 0;

    /**
     * Interface function for checkPath.
     * checks the validity of some file's URI
     * @param Uri - URI of a file.
     * @return true if URI is valid, false otherwise.
     */
    virtual bool checkPath(QString &Uri) = 0;
    };

#endif //MOUNTPOINTINTERFACE_H
