/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


//INCLUDES
#include <QTextStream>
#include <QDir>

#include "fslog.h"
#include "fsconstants.h"

//GLOBAL VARIABLES
QFile logFile;

// --------------------------------------------------------------------
// MyLog::MyLog()
// Constructor - Created the path required & the log file inside it
// --------------------------------------------------------------------
MyLog::MyLog()
    {
    QDir d;
    d.mkpath(LOG_DIR);
    logFile.setFileName(LOG_FILE);

    if (!logFile.open(QIODevice::WriteOnly | QIODevice::Text))
        {
        return;
        }
    logFile.write("***************BEGIN********************\n");
    }

// --------------------------------------------------------------------
// MyLog::~MyLog()
// Destructor - closes the log file
// --------------------------------------------------------------------
MyLog::~MyLog()
    {
    logFile.write("***************END*********************\n");
    logFile.close();
    }

// --------------------------------------------------------------------
// MyLog::writeToLogFile()
// static function to be called for logging in debug mode
// --------------------------------------------------------------------
void MyLog::writeToLogFile(QString str)
    {
    if (logFile.isOpen() == true)
        {
        QTextStream out(&logFile);
        out << str;
        }
    }
