/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef FILEIOWORKER_H_
#define FILEIOWORKER_H_

//INCLUDES
#include <QThread>
#include <QMap>
#include <QVariant>
#include "fsconstants.h"

//FORWARD DECLARATIONS
class QFile;

// CLASS DECLARATION

/**
 *  This class performs the file I/O operations
 *  @lib filesytemserviceplugin.qtplugin
 *  @since x.y
 */
class FileIOWorker : public QThread
    {
    Q_OBJECT

public:
    //constructor
    FileIOWorker();
    FileIOWorker(int taskId, QFile** file, int cbId, int maxLength=0, int pos=0);

    //destructor
    virtual ~FileIOWorker();

    //from base
    virtual void run();

    //for setting the file encoding format
    inline void setEncoding(QString encoding);

    //for setting data to be written in the file
    inline void setData(QString data);

    signals:
    //signal to notify the service class
    void FileIOWorkerSignal(int task, int tid, QMap<QString,QVariant> retMap);

private:
    //file io operations
    void run_close();
    void run_read();
    void run_readLine();
    void run_readBase64();
    void run_write();
    void run_writeLine();
    void run_flush();
    void run_seek();
    void run_writeBase64();

    //current task going on
    int m_task;

    //file handle we are operating on
    QFile** m_file;

    //callback id
    int m_cbId;

    //max length of data to be read
    int m_maxLength;

    //poition from which data to be read
    int m_pos;

    //data to be written
    QString m_data;

    //current encoding format
    QString m_encoding;
    };

#include "fsioworker.inl"
#endif /* FILEIOWORKER_H_ */
