/*
* ============================================================================
*  Name        : referenceService.h
*  Part of     : serviceframework / WRT
*  Description : Qt class for reference service
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef REFERENCESERVICE_H_
#define REFERENCESERVICE_H_

#include <QtCore>
#include "servicesecurityinterface.h"
#include "refserviceinterface.h"

class ReferenceService : public QObject,
                         public IRefTypeTest,
                         public IRefTypeTestV2,
                         public IServiceSecurity
{
    Q_OBJECT
    Q_INTERFACES(IRefTypeTest IRefTypeTestV2)

public:
    ReferenceService();
    virtual ~ReferenceService();
    void setSecuritySession(WRT::SecSession *aSecSession);

signals:
    void testIntAsyncCallback(int ret);

public slots:
    QVariant testMapSync(const QVariant& aObject);
    QVariant testListSync(const QVariant& aArray);
    void testIntAsync(int aInt);
    int testIntSync(int aInt);

private:
    void printQVariant(const QVariant& aQVariant, QByteArray& aOut, int aLevel=0);

protected:
    WRT::SecSession *iSecSession;
};

#endif // REFERENCESERVICE_H_

