/*
* ============================================================================
*  Name        : QGroupsIterator.h
*  Part of     : serviceprovider / WRT
*  Description : Qt Iterator for contacts
*  Version     : %version: 6 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __QGROUPSITERATOR_H
#define __QGROUPSITERATOR_H

//QT Include
#include <QtCore>

//Service framework include
#include "iterable.h"

//Local Include
#include "qcontactservice.h"

//Qt Mobility Include
#include <qtcontacts.h>

using namespace QTM_NAMESPACE;

/**
 * This is instantiated from qcontactservice when it gets a coreclass iterator.
 * Then it will translate core class datastrucure to qcontactData struture to satisfy from CJSE specs
*/

class QGroupsIterator : public QObject,
                          public WRT::IIterable     //Mandatory to inherit this
{
    Q_OBJECT

public:

    QGroupsIterator(QList<QContact> aGroups);


    /**
    * destructor
    * @since x.y
    * @param
    * @return
    */
    ~QGroupsIterator();

public slots:
    /**
     * resets the index, if present
     * @since x.y
     * @param
     * @return
     */
    void reset();


    /**
    * returns iHasNext.Essential to find whether to continue looping.
    * Without this the entire itertor might go crazy
    * @since x.y
    * @param
    * @return ture or false
    */
    virtual bool hasNext();


    /**
    * returns the next contact in qContactData format.
    * @since x.y
    * @param
    * @return qContactData
    */
    virtual QVariant next();

    /**
    * To clear resources
    * @since x.y
    * @param
    * @return
    */
    void close();

private:
    QListIterator<QContact> iGroupIter;

    /**
    * One of Enum TOperationType.
    */
    int iWhoAmI;


    /**
     * Has next flag.Used to find the end of iteration
     * @since x.y
     */
    bool iHasNext;

};

#endif //__QCONTACTS_ITERATOR_H_
