/*
 * ============================================================================
 *  Name        : qcommlogiterator.h
 *  Part of     : serviceframework / WRT
 *  Description : iterator for CommLog Service Provider
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __QCOMMLOGITERATOR_H
#define __QCOMMLOGITERATOR_H

//QT Include
#include <QVariant>
//Service framework include
#include "iterable.h"

/*
 * This is instantiated from qeventservice when it gets a coreclass iterator.
 */
class QCommLogIterator : public QObject, public WRT::IIterable //Mandatory to inherit this
    {
Q_OBJECT

public:

    //Constructor of Iterator object
    QCommLogIterator(QVariantList aList, int aTransactionId);

    //Destructor of Iterator object
    ~QCommLogIterator();

public slots:

    //Reset the index, if present
    void reset();

    //Has next element in Iterator object
    virtual bool hasNext();

    //Take next element in Iterator object
    virtual QVariant next();

    //Close Iterator. Free resources
    void close();

private:
    //List contain SMS and CALL events
    QVariantList iList;
    //Iterator object
    QListIterator<QVariant> * iIterator;
    };

#endif //__QCOMMLOGITERATOR_H
