/*
 * ============================================================================
 *  Name        : qcommlogiterator.h
 *  Part of     : serviceframework / WRT
 *  Description : iterator for CommLog Service Provider
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "qcommlogiterator.h"

QCommLogIterator::QCommLogIterator(QVariantList aList, int /*aTransactionId*/)
                        : iList (aList)
{
    iIterator = new QListIterator<QVariant>(iList);
}

void QCommLogIterator::reset()
{
    if (iIterator)
    {
        delete iIterator;
        iIterator = NULL;
    }
    iIterator = new QListIterator<QVariant>(iList);
}


QCommLogIterator::~QCommLogIterator()
{
    if (iIterator)
    {
        delete iIterator;
        iIterator = NULL;
    }
}

bool QCommLogIterator::hasNext()
{
    if (iIterator)
    {
        return iIterator->hasNext();
    }
    return false;
}

QVariant QCommLogIterator::next()
{
    if (iIterator)
    {
        if (iIterator->hasNext())
        {
            return iIterator->next();
        }
    }
    return 0;
}


void QCommLogIterator::close()
{
    if (iIterator)
    {
        delete iIterator;
        iIterator = NULL;
    }
}
