/*
 * ============================================================================
 *  Name        : qcommlogevent.cpp
 *  Part of     : serviceframework / WRT
 *  Description : Event class for CommLog service provider
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QDebug>

#include "qcommlogevent.h"
#include "qcommlogkeyconstants.h"

Event::Event()
{
}

Event::Event(const Event &other)
{
    //RTComElEvent fields
    id = other.id;
    serviceId = other.serviceId;
    typeId = other.typeId;
    storageTime = other.storageTime;
    startTime = other.startTime;
    endTime = other.endTime;
    isRead = other.isRead;
    flags = other.flags;
    bytesReceived = other.bytesReceived;
    bytesSent = other.bytesSent;
    localUid = other.localUid;
    localName = other.localName;
    remoteName = other.remoteName;
    remoteUid = other.remoteUid;
    remoteEbookUid = other.remoteEbookUid;
    channel = other.channel;
    freeText = other.freeText;
    groupUid = other.groupUid;
    service = other.service;
    eventType = other.eventType;
    additionalText = other.additionalText;
    iconName = other.iconName;
    pangoMarkup = other.pangoMarkup;
    direction = other.direction;
    //RTComeElEvent fields end

    //Other fields

    status = other.status;
    tpMessageId = other.tpMessageId;
    contactId = other.contactId;
    eventCount = other.eventCount;
}

Event &Event::operator=(const Event &other)
{
    //RTComElEvent fields
    id = other.id;
    serviceId = other.serviceId;
    typeId = other.typeId;
    storageTime = other.storageTime;
    startTime = other.startTime;
    endTime = other.endTime;
    isRead = other.isRead;
    flags = other.flags;
    bytesReceived = other.bytesReceived;
    bytesSent = other.bytesSent;
    localUid = other.localUid;
    localName = other.localName;
    remoteName = other.remoteName;
    remoteUid = other.remoteUid;
    remoteEbookUid = other.remoteEbookUid;
    channel = other.channel;
    freeText = other.freeText;
    groupUid = other.groupUid;
    service = other.service;
    eventType = other.eventType;
    additionalText = other.additionalText;
    iconName = other.iconName;
    pangoMarkup = other.pangoMarkup;
    direction = other.direction;
    //RTComeElEvent fields end

    //Other fields

    status = other.status;
    tpMessageId = other.tpMessageId;
    contactId = other.contactId;
    eventCount = other.eventCount;

    return *this;
}

Event::~Event()
{
}
QVariant Event::data(int column)
{
    QVariant var;

    switch (column) {
    case Id:
        var = id;
        break;
    case ServiceId:
        var = serviceId;
        break;
    case TypeId:
        var = typeId;
        break;
    case StorageTime:
        var = storageTime;
        break;
    case StartTime:
        var = startTime;
        break;
    case EndTime:
        var = endTime;
        break;
    case IsRead:
        var = isRead;
        break;
    case Flags:
        var = (int)flags;
        break;
    case BytesSent:
        var = bytesSent;
        break;
    case BytesReceived:
        var = bytesReceived;
        break;
    case LocalUid:
        var = localUid;
        break;
    case LocalName:
        var = localName;
        break;
    case RemoteUid:
        var = remoteUid;
        break;
    case RemoteName:
        var = remoteName;
        break;
    case RemoteEbookUid:
        var = remoteEbookUid;
        break;
    case Channel:
        var = channel;
        break;
    case FreeText:
        var = freeText;
        break;
    case GroupUid:
        var = groupUid;
        break;
    case Service:
        var = service;
        break;
    case EventType:
        var = eventType;
        break;
    case AdditionalText:
        var = additionalText;
        break;
    case IconName:
        var = iconName;
        break;
    case PangoMarkup:
        var = pangoMarkup;
        break;
    case Direction:
        var = direction;
        break;
    case Status:
        var = status;
        break;
    case ContactId:
        var = contactId;
        break;
    case TpMessageId:
        var = tpMessageId;
        break;
    case EventCount :
        var = eventCount;
        break;
    default:
        qDebug() << "Event::data: invalid column id??" << column;
        break;
    }

    return var;
}

bool Event::isValid() const
{
    return (id != -1);
}

QString Event::columnName(int column)
{
    QString name;

    switch (column) {
    case Id:
        name = kid;
        break;
    case ServiceId:
        name = kserviceid;
        break;
    case TypeId:
        name = ktypeid;
        break;
    case StorageTime:
        name = kstoragetime;
        break;
    case StartTime:
        name = kstarttime;
        break;
    case EndTime:
        name = kendtime;
        break;
    case IsRead:
        name = kisread;
        break;
    case Flags:
        name = kflags;
        break;
    case BytesSent:
        name = kbytessent;
        break;
    case BytesReceived:
        name = kbytesreceived;
        break;
    case LocalUid:
        name = klocaluid;
        break;
    case LocalName:
        name = klocalname;
        break;
    case RemoteUid:
        name = kremoteuid;
        break;
    case RemoteName:
        name = kremotename;
        break;
    case RemoteEbookUid:
        name = kremoteebookuid;
        break;
    case Channel:
        name = kchannel;
        break;
    case FreeText:
        name = kfreetext;
        break;
    case GroupUid:
        name = kgroupuid;
        break;
    case Service:
        name = kservice;
        break;
    case EventType:
        name = keventtype;
        break;
    case AdditionalText:
        name = kadditionaltext;
        break;
    case IconName:
        name = kiconname;
        break;
    case PangoMarkup:
        name = kpangomarkup;
        break;
    case Direction:
        name = kdirection;
        break;
    case Status:
        name = kstatus;
        break;
    case ContactId:
        name = kcontactid;
        break;
    case TpMessageId:
        name = ktpmessageid;
        break;
    case EventCount :
        name = keventcount;
        break;
    default:
        qDebug() << "Event::data: invalid column id??" << column;
        break;
    }

    return name;
}

bool Event::operator==(const Event &other) const
{
    if (contactId == other.contactId &&
        remoteUid == other.remoteUid &&
        startTime == other.startTime &&
        endTime   == other.endTime   &&
        isRead    == other.isRead    &&
        direction == other.direction &&
        flags     == other.flags &&
        id        == other.id ) {
        return true;
    }

    return false;
}

//////////////////////////// G E T - A C C E S S O R S ////////////////////
int Event::getId() const
{
    return id;
}
int Event::getServiceId() const
{
    return serviceId;
}
Event::EventTypeId Event::getTypeId() const
{
    return typeId;
}

QTime Event::getStorageTime() const
{
    return storageTime;
}

QDateTime Event::getStartTime() const
{
    return startTime;
}

QDateTime Event::getEndTime() const
{
    return endTime;
}

bool Event::getIsRead() const
{
    return isRead;
}

Event::EventFlags Event::getFlags() const
{
    return flags;
}

int Event::getBytesSent() const
{
    return bytesSent;
}

int Event::getBytesReceived() const
{
    return bytesReceived;
}

QString Event::getLocalUid() const
{
    return localUid;
}

QString Event::getLocalName() const
{
    return localName;
}

QString Event::getRemoteUid() const
{
    return remoteUid;
}

QString Event::getRemoteName() const
{
    return remoteName;
}

QString Event::getRemoteEbookUid() const
{
    return remoteEbookUid;
}

QString Event::getChannel() const
{
    return channel;
}

QString Event::getFreeText() const
{
    return freeText;
}

QString Event::getGroupUid() const
{
    return groupUid;
}

QString Event::getService() const
{
    return service;
}

QString Event::getEventType() const
{
    return eventType;
}

QString Event::getAdditionalText() const
{
    return additionalText;
}

QString Event::getIconName() const
{
    return iconName;
}

QString Event::getPangoMarkup() const
{
    return pangoMarkup;
}

Event::EventDirection Event::getDirection() const
{
    return direction;
}

Event::EventStatus Event::getStatus() const
{
    return status;
}

int Event::getContactId() const
{
    return contactId;
}

uint Event::getTpMessageId() const
{
    return tpMessageId;
}


int Event::getEventCount() const
{
    return eventCount;
}

//////////////////////////////////// S E T - A C C E S S O R S ///////////////////////////
void Event::setId(int aid)
{
    id = aid;
}

void Event::setServiceId(Event::EventServiceId aserviceId)
{
    serviceId = aserviceId;
}

void Event::setTypeId(Event::EventTypeId atypeId)
{
    typeId = atypeId;
}

void Event::setStorageTime(const QTime &astorageTime)
{
    storageTime = astorageTime;
}

void Event::setStartTime(const QDateTime &astartTime)
{
    startTime = astartTime;
}

void Event::setEndTime(const QDateTime &aendTime)
{
    endTime = aendTime;
}

void Event::setIsRead(bool aisRead)
{
    isRead = aisRead;
}

void Event::setFlags(Event::EventFlags aflags)
{
    flags = aflags;
}

void Event::setBytesSent(int bytes)
{
    bytesSent = bytes;
}

void Event::setBytesReceived(int bytes)
{
    bytesReceived = bytes;
}

void Event::setLocalUid(const QString &uid)
{
    localUid = uid;
}

void Event::setLocalName(const QString &name)
{
    localName = name;
}

void Event::setRemoteUid(const QString &uid)
{
    remoteUid = uid;
}

void Event::setRemoteName(const QString &name)
{
    remoteName = name;
}

void Event::setRemoteEbookUid(const QString &uid)
{
    remoteEbookUid = uid;
}

void Event::setChannel(const QString &achannel)
{
    channel = achannel;
}

void Event::setFreeText(const QString &text)
{
    freeText = text;
}

void Event::setGroupUid(const QString &uid)
{
    groupUid = uid;
}

void Event::setService(const QString &aservice)
{
    service = aservice;
}

void Event::setEventType(const QString & eventtype)
{
    eventType = eventtype;
}

void Event::setAdditionalText(const QString &token)
{
    additionalText = token;
}

void Event::setIconName(const QString &iname)
{
    iconName = iname;
}

void Event::setPangoMarkup(const QString &pango)
{
    pangoMarkup = pango;
}
void Event::setDirection(Event::EventDirection adirection)
{
    direction = adirection;
}

void Event::setStatus( Event::EventStatus astatus )
{
    status = astatus;
}

void Event::setContactId(int id)
{
    contactId = id;
}

void Event::setTpMessageId(uint id)
{
    tpMessageId = id;
}

void Event::setEventCount( int count )
{
    eventCount = count;
}
