/*
 * ============================================================================
 *  Name        : qcommlogcallandsmsmodel.h
 *  Part of     : serviceframework / WRT
 *  Description : Call and SMS Model for CommLog service provider
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __COMM_CALL_AND_SMS_MODEL_H__
#define __COMM_CALL_AND_SMS_MODEL_H__

#include <QObject>
#include <QString>
#include <QVariant>
#include <QList>
#include <QMutex>
#include <QMap>
#include <eventlogger.h>


#include "qcommlogmodel.h"
#include "qcommlogfilter.h"



class CommCallAndSMSModel: public QObject
{
    Q_OBJECT

public:
    CommCallAndSMSModel();
    ~CommCallAndSMSModel();
    //Getting events using CommLogFilter
    bool getEvents(const CommLogFilter& aFilter, QVariantList& aEvents, int &aErrorCode, QString& aErrorMessage);
    //Getting event by ID
    QVariantMap getEvent(int aEventId);
    //Delete event by ID
    bool deleteEvent(int aEventId);

private:
    //SMS db init
    bool smsInit();
    //CALL db init
    bool callInit();
    //Adding events to list by some filter
    void fillDataFromModel(const CommLogFilter& aFilter, CommHistoryModel & aModel, QVariantList& aEvents);
    //Check event to add in list
    bool checkFilter(const CommLogFilter& aFilter, const QVariantMap& aEvent) const;

private:
    /*SMS model*/
    CommHistorySmsModel iSmsModel;
    bool iSmsModelInitialized;
    QMutex iSMSMutex;

    /*Call model*/
    CommHistoryCallModel iCallModel;
    bool iCallModelInitialized;
    QMutex iCallMutex;

    /*Event object*/
    RTComEl *dbElement;

};

#endif //__COMM_CALL_AND_SMS_MODEL_H__
