# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

TEMPLATE = lib
CONFIG += plugin
symbian { 
    CONFIG(debug):CAMERASVC_SRC_PATH = ./platform/s60/
    CONFIG(debug):CAMERASVC_INC_PATH = ./platform/s60/
    CONFIG(release):CAMERASVC_SRC_PATH = ./platform/s60/
    CONFIG(release):CAMERASVC_INC_PATH = ./platform/s60/
}
maemo {
 maemo5 {
    CONFIG(release):DEFINES += QT_NO_DEBUG_OUTPUT
    CONFIG(debug):CAMERA_SRC_PATH = ./platform/maemo5/
    CONFIG(debug):CAMERA_INC_PATH = ./platform/maemo5/
    CONFIG(release):CAMERA_SRC_PATH = ./platform/maemo5/
    CONFIG(release):CAMERA_INC_PATH = ./platform/maemo5/
}
else {
    CONFIG(debug):CAMERASVC_SRC_PATH = ./platform/maemo/
    CONFIG(debug):CAMERASVC_INC_PATH = ./platform/maemo/
    CONFIG(release):CAMERASVC_SRC_PATH = ./platform/maemo/
    CONFIG(release):CAMERASVC_INC_PATH = ./platform/maemo/
}

}

symbian { 
HEADERS =  $$CAMERASVC_INC_PATH/cameraformatdata.h \
           $$CAMERASVC_INC_PATH/cameraservice.h \
           $$CAMERASVC_INC_PATH/cameracommon.h \
           $$CAMERASVC_INC_PATH/mgconsts.h \
           $$CAMERASVC_INC_PATH/mqueryobserver.h \
           $$CAMERASVC_INC_PATH/mgservice.hrh \
					 $$CAMERASVC_INC_PATH/qcameraservice.h \
					 $$CAMERASVC_INC_PATH/qcameraconstants.h \
           ./qcameraserviceplugin.h \           
           ./qcameraserviceinterface.h
           
SOURCES = $$CAMERASVC_SRC_PATH/cameraformatdata.cpp \
          $$CAMERASVC_SRC_PATH/cameraservice.cpp \
          $$CAMERASVC_SRC_PATH/mgservice.cpp  \
          $$CAMERASVC_SRC_PATH/mqueryobserver.cpp  \          
          $$CAMERASVC_SRC_PATH/qcameraservice.cpp \
          ./qcameraserviceplugin.cpp
} 

maemo {
  maemo5 {
    HEADERS =  $$CAMERA_INC_PATH/qcameraservice.h \
               $$CAMERA_INC_PATH/qcameraconstants.h \
               ./qcameraserviceplugin.h \
               ./qcameraserviceinterface.h

    SOURCES = $$CAMERA_SRC_PATH/qcameraservice.cpp \
              ./qcameraserviceplugin.cpp

  }
  else {
    HEADERS =  $$CAMERASVC_INC_PATH/qcameraservice.h \
               $$CAMERASVC_INC_PATH/qcameraconstants.h \
               $$CAMERASVC_INC_PATH/cameraObserver.h \
               ./qcameraserviceplugin.h \
               ./qcameraserviceinterface.h
           
    SOURCES = $$CAMERASVC_SRC_PATH/qcameraservice.cpp \
              $$CAMERASVC_SRC_PATH/cameraObserver.cpp \
              ./qcameraserviceplugin.cpp
  }
}


VERSION = 3.0.0  
TARGET = WrtApiCamera
include(../cwrtservice.pri)
#INCLUDEPATH += APP_LAYER_SYSTEMINCLUDE
symbian { 
    TARGET.CAPABILITY = ALL \
        -TCB
    TARGET.EPOCALLOWDLLDATA = 1
    TARGET.UID3 = 0x2002614F
    LIBS += -lefsrv \
        -lplatformenv \
		    -leuser \
	      -lbafl \       
		-lImagingConfigManager \
        -lmdeclient \
        -ltzclient \
        -lapgrfx \
        -lapparc \
        -lws32 \
        -leikcore \
        -lcone
                 
    TARGET.sources = ./descriptionxml/cameraserviceplugin.xml
    TARGET.path = /private/102829B8/import
    DEPLOYMENT += TARGET
    #QMAKE_POST_LINK += xcopy .\\qmakepluginstubs  \\epoc32\\data\\Z\\resource\\qt\\sfwplugin /H /I /E           
} maemo {
maemo5 {
    INCLUDEPATH += $$CWRT_INCLUDE \
                   $$CAMERA_INC_PATH
    # Build against wrt-dev package
    cwrt-services {
        LIBS += -L/usr/lib -lWrtSecurityManager
        INCLUDEPATH += /usr/include/cwrt/security
        INCLUDEPATH += /usr/include/cwrt/servicefw
    }
}
else {
        LIBS += /usr/lib/libqcamera.so
    LIBS += /usr/lib/libcamerainterface.so

    TARGET.sources = ./descriptionxml/cameraserviceplugin.xml
    INCLUDEPATH += $$CWRT_INCLUDE \
                   /usr/include/qcamera/ \
                   /usr/include/camera-ui/service/\
                   $$CAMERASVC_INC_PATH/ \
                   $$MAEMO_HOME/services
    #CONFIG += dui camera-service
    CONFIG += camera-service
    INCLUDEPATH += . /usr/include/camera-ui
    LIBS += -lcamerainterface
}
}
