/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "qcalendarserviceplugin.h"
#include "service.h"
#include "qcalendarservice.h"
#include <QtCore>
#include <QMap>
/**
 * Default constructor
 */
QCalendarServicePlugin::QCalendarServicePlugin()
{
}

/**
 * Destructor
 */
QCalendarServicePlugin::~QCalendarServicePlugin()
{
}

/**
 * This API is used to instantiate Calendar service.
 * @param refCounted true if reference counted object.
 * @param secSession Security Manager session - not owned
 * @return interface pointer to Calendar Service object
 */
IServiceBase* QCalendarServicePlugin::getServiceBase(bool refCounted, WRT::SecSession *secSession)
{

    IServiceBase* pInterface(NULL);
    CREATE_SERVICE_OBJECT(QCalendarService, pInterface, refCounted);
    if (pInterface) {
        // add children if applicable, child ownership transferred
        IServiceSecurity *security=NULL;
        if (refCounted) {
            security = static_cast<IServiceSecurity*>(serviceObject);
        }
        else  {
            security = static_cast<IServiceSecurity*>(singletonServiceObject);
        }
        security->setSecuritySession(secSession);
    }
    return pInterface;
}

Q_EXPORT_PLUGIN(QCalendarServicePlugin);
