/*
* ============================================================================
*  Name        : qcalendariterator.h
*  Part of     : serviceframework / WRT
*  Description : iterator class for calendar service
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef QCALENDARITERATOR_H
#define QCALENDARITERATOR_H

#include <QtCore>
#include <QObject>
#include <QList>
#include <QVariant>
#include "iterable.h"

//QCalendarIterator class. Implements abstract interface to iterate over a QVariantList
class QCalendarIterator : public QObject, public WRT::IIterable	
{
    Q_OBJECT
public:
    //construcot
     QCalendarIterator(QList<QVariantMap> aVariantList);
     //destructor
    ~QCalendarIterator();
public slots:
    //resets iterator
    void reset();
    //check if there is more item available
    virtual bool hasNext();
    //gets current item in the collection and prepares for next item
    virtual QVariant next();
    //frees resources in the collection
    void close();

private:
    //iterator
    QListIterator<QVariantMap> iIterator;

};

#endif //QCALENDARITERATOR_H
