/*
* ============================================================================
*  Name        : qcalendariterator.cpp
*  Part of     : serviceframework / WRT
*  Description : iterator class for calendar service
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "qcalendariterator.h"
#include "qcalendarhelper.h"

QCalendarIterator::QCalendarIterator(QList<QVariantMap> aVariantList): iIterator(aVariantList)
{
}

void QCalendarIterator::reset()
{
}

bool QCalendarIterator::hasNext()
{
    return iIterator.hasNext();
}

QVariant QCalendarIterator::next()
{
    QVariant var = NULL;
    if (iIterator.hasNext())
    {
        var = iIterator.next();
    }
    qDebug() << "QCalendarIterator::next(): var: " << var;
    return var;
}

void QCalendarIterator::close()
{
}

QCalendarIterator::~QCalendarIterator()
{
}
