/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QtCore/QCoreApplication>
#include <QtCore/QDir>
#include <QtCore/QFile>
#include <QtCore/QString>

#ifdef __SYMBIAN32__
#include <APACMDLN.H>
#include <apgcli.h>
#include <W32STD.H>
#include <APGTASK.H>
#include <caf/caf.h>
#include <swi/swispubsubdefs.h>
#include <e32property.h>
#include <bautils.h>
#endif

// CONSTANTS
static const char BACKUP_PATH[] = "c:\\system\\data\\sfw\\";
static const char IMPORT_FOLDER[] = "import\\";
static const char XML_EXT[] = ".xml";
static const char CURRENT_DIR[] = ".";
static const char PARENT_DIR[] = "..";

#ifdef __SYMBIAN32__
    static const char RESOLVER_PRIVATE_PATH[] = "c:\\private\\102829b8\\";
#endif


void removeDir(QString path)
{
    QDir dir(path);
    QFileInfoList fileInfoList = dir.entryInfoList();
    foreach (const QFileInfo& fileInfo, fileInfoList) {
        if (fileInfo.isDir() && fileInfo.fileName() != CURRENT_DIR && fileInfo.fileName() != PARENT_DIR) {
            removeDir(fileInfo.filePath());
            dir.rmdir(fileInfo.filePath());
        } else if (fileInfo.isFile()){
            QFile file(fileInfo.filePath());
            file.remove();
        }
    }
    dir.rmdir(path);
}

void StartBackup()
{
#ifdef __SYMBIAN32__
    QDir dir(RESOLVER_PRIVATE_PATH);
    TInt state(-1);
    TInt err( RProperty::Get( TUid::Uid(KUidSystemCategoryValue),
                              Swi::KUidSoftwareInstallKey,
                              state));
    //installation
    if ( state == Swi::ESwisInstall ) {
        //backup path exists :
        //some services has already been registered with service framework
        //their information should be recovered to resolver private folder
        if (dir.exists(BACKUP_PATH)) {
            //no new service is installed after unistallation of service framework
            if (!dir.exists(RESOLVER_PRIVATE_PATH)) {
                dir.rename(BACKUP_PATH, RESOLVER_PRIVATE_PATH);
            } else {
                //some new services are installed after uninstallation of service framework
                QString resolverImportPath = QString(RESOLVER_PRIVATE_PATH) + QString(IMPORT_FOLDER);
                QString backupDirImportPath = QString(BACKUP_PATH) + QString(IMPORT_FOLDER);
                QDir resolverImportDir(resolverImportPath , '*' + QString(XML_EXT) );
                QStringList xmlFileNames =  resolverImportDir.entryList();
                if (xmlFileNames.count() > 0) {
                    //copy xml files in resolver's import folder to backup import folder
                    foreach (const QString &xmlFileName, xmlFileNames ) {
                        //to avoid overwriting xml files, check if a file with the same name already exists in backup import folder
                        //in that case rename the new file, by adding some digits to end of file name
                        QString newFileName = backupDirImportPath + xmlFileName;
                        QFile file(newFileName);
                        char counter('0');
                        while (file.exists()) {
                            newFileName.insert(newFileName.lastIndexOf(XML_EXT), QChar(counter));
                            counter += 1;
                            file.setFileName(newFileName);
                        }
                        QFile::copy(resolverImportPath + xmlFileName, newFileName);
                    }
                }
                removeDir(RESOLVER_PRIVATE_PATH);
                dir.rename(BACKUP_PATH, RESOLVER_PRIVATE_PATH);
            }
        }
    } else if ( state == Swi::ESwisUninstall ) {
        if (dir.exists(RESOLVER_PRIVATE_PATH)) {
            if (dir.exists(BACKUP_PATH)) {
                removeDir(BACKUP_PATH);
            }
            dir.rename(RESOLVER_PRIVATE_PATH, BACKUP_PATH);
        }
    }
#endif
}


int main()
{
    StartBackup();
    return 0;
}
