/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef serviceresolutioncriteria_h
#define serviceresolutioncriteria_h

#include <Qt/qglobal.h>
#include <QString>

namespace WRT {

    #if defined(QT_SERVICERESOLUTION_PRO)
    #define RESOLUTION_API Q_DECL_EXPORT
    #else
    #define RESOLUTION_API Q_DECL_IMPORT
    #endif


    class RESOLUTION_API ServiceResolutionCriteria
    {

    public:

        ServiceResolutionCriteria();

        ~ServiceResolutionCriteria();

        void setServiceName(const QString& aServiceName);

        void setInterfaceName(const QString& anInterfaceName);

        void setInterfaceVersion(const QString& aVersion);

        QString serviceName();

        QString interfaceName();

        QString interfaceVersion();

        bool isValid();

        QByteArray serialize();

        bool deserialize(const QByteArray& aDataStream);

    private:
        QString m_criteriaServiceName;
        QString m_criteriaInterfaceName;
        QString m_criteriaInterfaceVersion;
    };

}

#endif // serviceresolutioncriteria_h
