/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef serviceinfolist_h
#define serviceinfolist_h

#include <QList>
#include <serviceinfo.h>

#if defined(QT_SERVICERESOLUTION_PRO)
#define SERVICEINFO_API Q_DECL_EXPORT
#else
#define SERVICEINFO_API Q_DECL_IMPORT
#endif

namespace WRT {

    class SERVICEINFO_API ServiceInfoList
    {
    public:

        ServiceInfoList(void);

        ~ServiceInfoList(void);

        int count();

        ServiceInfo getService(int aServiceIndex);

        void deleteService(int aServiceIndex);

        void addServiceInfo(const ServiceInfo& aServiceInfo);

        QByteArray serialize();

        bool deserialize(const QByteArray& aDataStream);


    private:

        QList<ServiceInfo> m_services;

    };
}
#endif //serviceinfolist_h
