/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "sfwparameter.h"

namespace WRT {

// ------------------------------------------------------------------------------
// SFWParameter::SFWParameter
// Class constructor
// ------------------------------------------------------------------------------
//
SFWParameter::SFWParameter(const QString& aName, const QString& aType,
        const QString& aDescription, bool aStatus)
{
    parameterName = aName;
    parameterType = aType;
    parameterDescription = aDescription;
    parameterStatus = aStatus;
}

// ------------------------------------------------------------------------------
// SFWParameter::~SFWParameter
// Class destructor
// ------------------------------------------------------------------------------
//
SFWParameter::~SFWParameter(void)
{
}

// ------------------------------------------------------------------------------
// SFWParameter::name
// Gets the parameter name
// ------------------------------------------------------------------------------
//
QString SFWParameter::name()
{
    return parameterName;
}

// ------------------------------------------------------------------------------
// SFWParameter::type
// Gets the parameter type
// ------------------------------------------------------------------------------
//
QString SFWParameter::type()
{
    return parameterType;
}

// ------------------------------------------------------------------------------
// SFWParameter::description
// Gets the parameter description
// ------------------------------------------------------------------------------
//
QString SFWParameter::description()
{
    return parameterDescription;
}

// ------------------------------------------------------------------------------
// SFWParameter::status
// Gets the parameter status
// ------------------------------------------------------------------------------
//
bool SFWParameter::mandatory()
{
    return parameterStatus;
}
}
