/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "sfwinterface.h"

namespace WRT {

/*!
    \class SFWInterface

    SFWInterface class is used by service metadata parser to keep interface related information (interface name, version and capabilities)
    from service XML registry file\n
*/


/*!
 *  Class constructor
 *
 */
SFWInterface::SFWInterface()
{
}

/*!
 *  Class destructor
 */
SFWInterface::~SFWInterface()
{
}

/*!
 *  Gets the interface name
 *
 * @return interface name
 */
QString SFWInterface::name()
{
    return m_name;
}

/*!
 *  Gets the interface version
 *
 * @return interface version
 */
QString  SFWInterface::version()
{
    return m_version;
}

/*!
 *  Gets the interface capabalities list
 *
 * @return interface capabalities list or empty list if it is not available
 */
QStringList  SFWInterface::capabalitiesList()
{
    QStringList emptyList;
    if (m_capabilities.count() > 0 ) {
        return m_capabilities.split(',');
    } else {
        return emptyList;
    }
}

/*!
 *  Gets the interface capabalities
 *
 * @return interface capabalities as a string
 */
QString  SFWInterface::capabalities()
{
    return m_capabilities;
}

/*!
 *  Sets the interface version
 *
 * @param aVersion
 */
void SFWInterface::setVersion(const QString& aVersion)
{
    m_version = aVersion;
}

/*!
 *  Sets the interface name
 *
 * @param aName
 */
void SFWInterface::setName(const QString& aName)
{
    m_name = aName;
}

/*!
 *  Sets the interface capabilities list
 *
 * @param aCapabilities
 */
void SFWInterface::setCapabilities(const QString& aCapabilities)
{
    m_capabilities = aCapabilities;
}

/*!
 *  Sets interface description
 *
 * @param aDescription
 */
void SFWInterface::setDescription(const QString& aDescription)
{
    m_description = aDescription;
}

/*!
 *  Gets interface description
 *
 * @return interface description
 */
QString SFWInterface::description()
{
    return m_description;
}

}
