/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef servicehandler_p_h
#define servicehandler_p_h

#include "servicehandler.h"

namespace WRT
{
    class ServiceHandler;
    static const char *ServiceHandlerErrDesc[] = {"No Error",
                                                  "Error loading service provider plugin",
                                                  "Error service not found",
                                                  "Error getting list of services",
                                                  "Error connecting to resolver",
                                                  "Error client not allowed to access service"
                                                 };

    /*!
     \class ServiceHandlerPrivate
     Keeps all service handler's private members and methods.
     A pointer to this class is declared in ServiceHandler class
     */
    class ServiceHandlerPrivate
    {
        public:
            //! ServiceHandlerPrivate::ErrorType
            /*!
             This enum describes the errors that may occur in service handler
             */
            enum ErrorType {
                SFW_ERROR_NO_ERROR,                                       /*!< No error */
                SFW_ERROR_LOADING_PLUGIN,                                 /*!< Error loading plugin */
                SFW_ERROR_SERVICE_NOT_FOUND,                              /*!< Error service not found */
                SFW_ERROR_GETTING_LIS_OF_SERVICES,                        /*!< Error getiing list of services */
                SFW_ERROR_CONNECTING_TO_RESOLVER,                         /*!< Error connecting to resolver */
                SFW_ERROR_CLIENT_NOT_ALLOWED_TO_ACCESS_SERVICE            /*!< Error client not allowed to access service */
            };
            ~ServiceHandlerPrivate();

            ServiceHandlerPrivate(ServiceHandler *);

            IServiceBase* getServiceBase(const QString &aServiceName,
                                         ServiceInterfaceInfo& aInterfaceInfo,
                                         bool aRefCounted,
                                         SecSession *aSecSession);

            IServiceBase* loadPlugin(const QString& aDllName,
                                     bool aRefCounted,
                                     SecSession* aSecSession);

            QList<QPluginLoader*> m_loadedPlugins;
            ServiceFwIPC* m_session;
            bool m_isConnected;
            // Owned if not NULL, it is possible for javascript to get more than one objects
            QList<QObject*> m_objects;
            QByteArray m_ba;
        protected:
            friend class ServiceHandler;
            ServiceHandler* q;
    };
}
#endif //servicehandler_p_h
//end of file
