/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef serviceobjectbinding_h
#define serviceobjectbinding_h

#include "npdef.h"

#include <QHash>
#include "objectbinding.h"

class IServiceBase;

namespace WRT {
    class SignalForwarder;
    class BindingUtility;

    class ServiceObjectBinding : public ObjectBinding
    {
    public:
        ServiceObjectBinding(NPP npp);
        ~ServiceObjectBinding();

        //Overriding virtual methods of CScriptablePluginObjectBase
        virtual bool HasMethod(NPIdentifier methodId);
        virtual bool HasProperty(NPIdentifier propertyId);
        virtual bool GetProperty(NPIdentifier propertyId, NPVariant *result);
        virtual bool SetProperty(NPIdentifier propertyId, const NPVariant *value);
        virtual bool Invoke(NPIdentifier methodId, const NPVariant *args,
                            uint32_t argCount, NPVariant *result);
#if defined(QT_MOBILITY_SFW)
        void setInterface(QObject* aInterface,
                          BindingUtility& bindingUtility);
#else
        void setInterface(IServiceBase* aInterface,
                          BindingUtility& bindingUtility);
#endif
        void constructSignalIdentifiers();

    private:
        int connect(const NPString* signalSignature, const NPVariant* callback);
        bool disconnect(int id);
        int connectCallback(const NPVariant* callback, int signalIndex);

    private:
        QHash<QString, SignalForwarder*> m_hash; //owns forwarder object
        NPIdentifier m_addEventListener;
        NPIdentifier m_removeEventListener;
        NPIdentifier m_getInterface;
        NPIdentifier m_getLastErrCode;
        NPIdentifier m_getLastErrDescription;
        int m_connectedCounter;  // Counter for number of signals

        NPIdentifier* m_signals;              // List of signal identifiers
        QList<int> m_signalMethodOffset;      // Method offsets for each signal
        int m_signalCount;                    // Number of signals
#if defined(QT_MOBILITY_SFW)
        QObject* m_base;
#else
        IServiceBase* m_base;                 // Pointer to servicebase
#endif
        char* m_content;
    };

    DECLARE_NPOBJECT_CLASS_WITH_BASE(ServiceObjectBinding);
}
#endif //serviceobjectbinding_h
