/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef servicefatory_h
#define servicefatory_h

#include "bindingutility.h"
#include "scriptableobjectbase.h"
#include "sfwerrorhandler.h"

#if defined(QT_MOBILITY_SFW)
#include "qservicemanager.h"
using namespace QtMobility;
#else
#include "servicehandler.h"
#endif

namespace WRT {
    static const char *ServiceFactoryErrDesc[] ATTRIBUTE_USED  = {"No Error",
                                                                  "Method not found",
                                                                  "Number of parameter not correct",
                                                                  "Parameter type mismatch",
                                                                  "Security session not created"
                                                                  };

#if !defined(QT_MOBILITY_SFW)
    class ServiceHandler;
#endif
    class TrustSession;
    class SecSession;
    class ObjectBinding;

    class ServiceFactory : public NPScriptableObjectBase, public SFWErrorHandler
    {

     public:
        //! ServiceFactory::ErrorType
        /*!
         This enum describes the errors that may occur in calling service factory method
         */
        enum ErrorType {
            SFW_ERROR_NO_ERROR,                                       /*!< No error */
            SFW_ERROR_METHOD_NOT_FOUND,                               /*!< Can not find the plugin method*/
            SFW_ERROR_NUMBER_OF_PARAMETERS,                           /*!< Error in number of input parameters */
            SFW_ERROR_PARAMETER_TYPE_MISMATCH,                        /*!< Error an input parameter type mismatch*/
            SFW_ERROR_SECSESSION_ERROR                                /*!< Error creating a security session*/
        };

        ServiceFactory(NPP npp);
        ~ServiceFactory();

        //Overriding virtual methods
        virtual bool HasMethod(NPIdentifier methodId);
        virtual bool Invoke(NPIdentifier methodId, const NPVariant* args,
                            uint32_t argCount, NPVariant* result);
        virtual bool HasProperty(NPIdentifier propertyId);
        virtual bool GetProperty(NPIdentifier propertyId, NPVariant *result);
        virtual bool SetProperty(NPIdentifier propertyId, const NPVariant *value);
        NPObject* createBindingObject(NPClass* npClass);
        void removeBindingObject(ObjectBinding* bindingObject);

    private: //functions
        bool getServiceObject(const NPString *providerName,
                              const NPString *interfaceName,
                              const NPString *version,
                              NPVariant *result);

        bool getServiceProviders(NPVariant* result);
#if !defined(QT_MOBILITY_SFW)
        bool getServiceVersion(const NPString *providerName,
                                NPVariant* result);
#else
        QString getErrorText(QServiceManager::Error) const;
#endif
        void createTrustSession();
// enable secsession for all except in 3.1, 3.2 emulator environment
#if !defined(__WINSCW__) || defined(__S60_50__)
        bool createSecSession();
        QString getHostUrl();
#if defined(__SYMBIAN32__) && !defined(CWRT_S60_WEBKIT)
        // functions needed for Avkon browser only

        QString getClientName(const QString &aHostUrl);
        QString getClientPath(const QString &aHostUrl, const QString &aClientName);
#endif
#endif

    private: //variables
        NPIdentifier m_npidGetServiceObject;
        NPIdentifier m_npidListServices;
        NPIdentifier m_npidGetServiceVersion;
        NPIdentifier m_getLastErrCode;
        NPIdentifier m_getLastErrDescription;
        NPIdentifier m_setJSObjectProt;
        BindingUtility m_bindingUtility;
#if defined(QT_MOBILITY_SFW)
        QServiceManager *m_serviceManager;
#else
        ServiceHandler *m_ServiceHandler;
#endif
        TrustSession *m_TrustSession;
        SecSession *m_SecSession;
        QString m_CurrentDomain;
        NPIdentifier m_PropertyToken;
        char* m_content;
        QList<ObjectBinding*> m_bindingObjectList;
    };

    DECLARE_NPOBJECT_CLASS_WITH_BASE(ServiceFactory);

} // namespace

#endif //servicefatory_h
