/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef sfwlog_h
#define sfwlog_h

#ifdef _DEBUG
#include <QString>
#include <QByteArray>

#ifdef __SYMBIAN32__
#include <flogger.h>
#include <f32file.h>
#endif //__SYMBIAN32__

#define SFW_DEBUG1(s)               sfwDebug(s)
#define SFW_DEBUG2(s, a)            sfwDebug(s, a)
#define SFW_DEBUG3(s, a, b)         sfwDebug(s, a, b)
#define SFW_DEBUG4(s, a, b, c)      sfwDebug(s, a, b, c)
#define SFW_DEBUG5(s, a, b, c, d)   sfwDebug(s, a, b, c, d)
#define SFW_FUNC(fn)                FunctionTrace _s(fn);
#define SFW_FUNC_EX(fn)             FunctionTrace _t(fn, this);

// output debug messages to a log file as well as debug console if in Symbian
// in other platforms, only output to debug console
#ifdef __SYMBIAN32__
// folder name relative to c:\logs\, must be created manually
_LIT(KSfwLogDir, "sfw");
// name of the log file
_LIT(KSfwLogFile, "sfw_log.txt");
#endif //__SYMBIAN32__

inline void sfwDebug(const char* text, ...)
{
    va_list arguments;
    va_start(arguments,text);
    char buf[1024];
    qvsnprintf( buf, 1024, text, arguments );
    qDebug(buf);
    va_end(arguments);
#ifdef __SYMBIAN32__
    VA_LIST arguments_symbian;
    VA_START(arguments_symbian,text);
    TPtrC8 textDescriptor((TUint8 *)(text));
    RFileLogger::WriteFormat(KSfwLogDir(),KSfwLogFile(),EFileLoggingModeAppend,
            textDescriptor, arguments_symbian);
    VA_END(arguments_symbian);
#endif //__SYMBIAN32__
}

class FunctionTrace
{
public:
    explicit FunctionTrace(const char* aName, void* aThis=NULL):iStr(aName), iThis(aThis)
    {
        if (iThis)
        {
            QByteArray ba = iStr.toLatin1();
            sfwDebug("-->%s, 0x%08x", (const char *)ba.data(), iThis);
        }
        else
        {
            QByteArray ba = iStr.toLatin1();
            sfwDebug("-->%s", (const char *)ba.data());
        }
    }
    ~FunctionTrace()
    {
        if (iThis)
        {
            QByteArray ba = iStr.toLatin1();
            sfwDebug("<--%s, 0x%08x", (const char *)ba.data(), iThis);
        }
        else
        {
            QByteArray ba = iStr.toLatin1();
            sfwDebug("<--%s", (const char *)ba.data());
        }
    }
private:
    QString iStr;
    void* iThis;
};

#else
#define SFW_DEBUG1(s)
#define SFW_DEBUG2(s, a)
#define SFW_DEBUG3(s, a, b)
#define SFW_DEBUG4(s, a, b, c)
#define SFW_DEBUG5(s, a, b, c, d)
#define SFW_FUNC(fn)
#define SFW_FUNC_EX(fn)
#endif //_DEBUG

#endif //sfwlog_h
