/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef sfwexception_h
#define sfwexception_h

/*!
    SFW exception class.
    Service providers throw an object of this class to the binding layer when an error happens in
    running of one of their methods. The exception is caught in binding layer. In windows an
    exception is thrown to JS by calling NPN_SetException. Also information about last error are
    set by setLastErrCode, setLastErrDesc in binding layer to provider information for JS layer in
    case the platform does not support exception.
 */
class SFWException
{
    private :
        /*!
            keeps the code of error occurred
        */
        int m_errCode;
        /*!
            keeps the description of error occurred
        */
        QString m_errDesc;

    public:

        /*!
            Constructor
        */
        SFWException(int aErrCode, QString aErrDesc) {m_errCode = aErrCode; m_errDesc = aErrDesc;}

        /*!
            Returns m_errCode
        */
        int getErrCode() {return m_errCode;}
        /*!
            Returns m_errDesc
        */
        QString getErrDescription() {return m_errDesc;}
};
#endif //sfwexception_h
